package llnl.visit;

import java.util.Vector;

// ****************************************************************************
// Class: ColorAttributeList
//
// Purpose:
//    This class contains a list of ColorAttributes.
//
// Notes:      Autogenerated by xml2java.
//
// Programmer: xml2java
// Creation:   Thu Jul 31 16:19:11 PST 2003
//
// Modifications:
//   
// ****************************************************************************

public class ColorAttributeList extends AttributeSubject
{
    public ColorAttributeList()
    {
        super(1);

        colors = new Vector();
    }

    public ColorAttributeList(ColorAttributeList obj)
    {
        super(1);

        int i;

        // *** Copy the colors field ***
        colors = new Vector(obj.colors.size());
        for(i = 0; i < obj.colors.size(); ++i)
        {
            ColorAttribute newObj = (ColorAttribute)colors.elementAt(i);
            colors.addElement(new ColorAttribute(newObj));
        }


        SelectAll();
    }

    public boolean equals(ColorAttributeList obj)
    {
        int i;

        boolean colors_equal = (obj.colors.size() == colors.size());
        for(i = 0; (i < colors.size()) && colors_equal; ++i)
        {
            // Make references to ColorAttribute from Object.
            ColorAttribute colors1 = (ColorAttribute)colors.elementAt(i);
            ColorAttribute colors2 = (ColorAttribute)obj.colors.elementAt(i);
            colors_equal = colors1.equals(colors2);
        }

        // Create the return value
        return (colors_equal);
    }

    // Property setting methods
    // Property getting methods
    public Vector GetColors() { return colors; }

    // Write and read methods.
    public void WriteAtts(CommunicationBuffer buf)
    {
        if(WriteSelect(0, buf))
        {
            buf.WriteInt(colors.size());
            for(int i = 0; i < colors.size(); ++i)
            {
                ColorAttribute tmp = (ColorAttribute)colors.elementAt(i);
                tmp.Write(buf);
            }
        }
    }

    public void ReadAtts(int n, CommunicationBuffer buf)
    {
        buf.ReadByte();
        {
            int len = buf.ReadInt();
            colors.clear();
            for(int j = 0; j < len; ++j)
            {
                ColorAttribute tmp = new ColorAttribute();
                tmp.Read(buf);
                colors.addElement(tmp);
            }
        }
        Select(0);
    }

    // Attributegroup convenience methods
    public void AddColorAttribute(ColorAttribute obj)
    {
        colors.addElement(new ColorAttribute(obj));
        Select(0);
    }

    public void ClearColorAttributes()
    {
        colors.clear();
        Select(0);
    }

    public void RemoveColorAttribute(int index)
    {
        if(index >= 0 && index < colors.size())
        {
            colors.remove(index);
            Select(0);
        }
    }

    public int GetNumColorAttributes()
    {
        return colors.size();
    }

    public ColorAttribute GetColorAttribute(int i)
    {
        ColorAttribute tmp = (ColorAttribute)colors.elementAt(i);
        return tmp;
    }


    // Attributes
    private Vector colors; // vector of ColorAttribute objects
}

