package llnl.visit;

// ****************************************************************************
// Class: ColorAttribute
//
// Purpose:
//    This class contains RGBA color information
//
// Notes:      Autogenerated by xml2java.
//
// Programmer: xml2java
// Creation:   Fri Aug 9 13:36:19 PST 2002
//
// Modifications:
//   Brad Whitlock, Fri Aug 9 13:51:19 PST 2002
//   I changed the class so it uses ints internally and reads and writes
//   itself as bytes.
//
// ****************************************************************************

public class ColorAttribute extends AttributeSubject
{
    public ColorAttribute()
    {
        super(1);
        color = new int[4];
        color[0] = 0;
        color[1] = 0;
        color[2] = 0;
        color[3] = 255;
    }

    public ColorAttribute(ColorAttribute obj)
    {
        super(1);
        int i;

        color = new int[4];
        for(i = 0; i < 4; ++i)
            color[i] = obj.color[i];

        SelectAll();
    }

    public ColorAttribute(int r, int g, int b)
    {
        super(1);
        color = new int[4];
        color[0] = r;
        color[1] = g;
        color[2] = b;
        color[3] = 255;
    }

    public ColorAttribute(int r, int g, int b, int a)
    {
        super(1);
        color = new int[4];
        color[0] = r;
        color[1] = g;
        color[2] = b;
        color[3] = a;
    }

    public boolean equals(ColorAttribute obj)
    {
        int i;

        // Compare the color arrays.
        boolean color_equal = true;
        for(i = 0; i < 4 && color_equal; ++i)
            color_equal = (color[i] == obj.color[i]);

        // Create the return value
        return (color_equal);
    }

    // Property setting methods
    public void SetColor(int[] color_)
    {
        color[0] = color_[0];
        color[1] = color_[1];
        color[2] = color_[2];
        color[3] = color_[3];
        Select(0);
    }

    // Property getting methods
    public int[] GetColor() { return color; }
    public int Red() { return color[0]; }
    public int Green() { return color[1]; }
    public int Blue() { return color[2]; }
    public int Alpha() { return color[3]; }

    // Write and read methods.
    public void WriteAtts(CommunicationBuffer buf)
    {
        if(WriteSelect(0, buf))
        {
            byte b[] = new byte[4];
            for(int i = 0; i < 4; ++i)
                b[i] = (byte)color[i];
            buf.WriteByteArray(b, true);
        }
    }

    public void ReadAtts(int n, CommunicationBuffer buf)
    {
        buf.ReadByte();
        byte[] b = buf.ReadByteArray();
        for(int i = 0; i < 4; ++i)
        {
            color[i] = (int)b[i];
            color[i] += ((color[i] < 0) ? 256 : 0);
        }
        Select(0);    
    }

    // Attributes
    private int[] color;
}

