package llnl.visit;


// ****************************************************************************
// Class: AppearanceAttributes
//
// Purpose:
//    This class contains the GUI/viewer appearance attributes.
//
// Notes:      Autogenerated by xml2java.
//
// Programmer: xml2java
// Creation:   Thu Jul 31 16:19:10 PST 2003
//
// Modifications:
//   
// ****************************************************************************

public class AppearanceAttributes extends AttributeSubject
{
    public AppearanceAttributes()
    {
        super(5);

        background = new String("#c0c0c0");
        foreground = new String("#000000");
        fontDescription = new String("-adobe-helvetica-bold-r-normal--14-140-75-75-p-82-iso8859-1");
        style = new String("motif");
        orientation = 0;
    }

    public AppearanceAttributes(AppearanceAttributes obj)
    {
        super(5);

        background = new String(obj.background);
        foreground = new String(obj.foreground);
        fontDescription = new String(obj.fontDescription);
        style = new String(obj.style);
        orientation = obj.orientation;

        SelectAll();
    }

    public boolean equals(AppearanceAttributes obj)
    {
        // Create the return value
        return ((background == obj.background) &&
                (foreground == obj.foreground) &&
                (fontDescription == obj.fontDescription) &&
                (style == obj.style) &&
                (orientation == obj.orientation));
    }

    // Property setting methods
    public void SetBackground(String background_)
    {
        background = background_;
        Select(0);
    }

    public void SetForeground(String foreground_)
    {
        foreground = foreground_;
        Select(1);
    }

    public void SetFontDescription(String fontDescription_)
    {
        fontDescription = fontDescription_;
        Select(2);
    }

    public void SetStyle(String style_)
    {
        style = style_;
        Select(3);
    }

    public void SetOrientation(int orientation_)
    {
        orientation = orientation_;
        Select(4);
    }

    // Property getting methods
    public String GetBackground() { return background; }
    public String GetForeground() { return foreground; }
    public String GetFontDescription() { return fontDescription; }
    public String GetStyle() { return style; }
    public int    GetOrientation() { return orientation; }

    // Write and read methods.
    public void WriteAtts(CommunicationBuffer buf)
    {
        if(WriteSelect(0, buf))
            buf.WriteString(background);
        if(WriteSelect(1, buf))
            buf.WriteString(foreground);
        if(WriteSelect(2, buf))
            buf.WriteString(fontDescription);
        if(WriteSelect(3, buf))
            buf.WriteString(style);
        if(WriteSelect(4, buf))
            buf.WriteInt(orientation);
    }

    public void ReadAtts(int n, CommunicationBuffer buf)
    {
        for(int i = 0; i < n; ++i)
        {
            int index = (int)buf.ReadByte();
            switch(index)
            {
            case 0:
                SetBackground(buf.ReadString());
                break;
            case 1:
                SetForeground(buf.ReadString());
                break;
            case 2:
                SetFontDescription(buf.ReadString());
                break;
            case 3:
                SetStyle(buf.ReadString());
                break;
            case 4:
                SetOrientation(buf.ReadInt());
                break;
            }
        }
    }


    // Attributes
    private String background;
    private String foreground;
    private String fontDescription;
    private String style;
    private int    orientation;
}

