package llnl.visit;

import java.util.Vector;

// ****************************************************************************
// Class: AnnotationObjectList
//
// Purpose:
//    Contains a list of AnnotationObjectAttributes
//
// Notes:      Autogenerated by xml2java.
//
// Programmer: xml2java
// Creation:   Wed Oct 29 10:49:13 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

public class AnnotationObjectList extends AttributeSubject
{
    // Constants
    public final static int ANNOTATIONTYPE_TEXT2D = 0;
    public final static int ANNOTATIONTYPE_TEXT3D = 1;
    public final static int ANNOTATIONTYPE_TIMESLIDER = 2;
    public final static int ANNOTATIONTYPE_ARROW2D = 3;
    public final static int ANNOTATIONTYPE_ARROW3D = 4;
    public final static int ANNOTATIONTYPE_BOX = 5;
    public final static int ANNOTATIONTYPE_IMAGE = 6;


    public AnnotationObjectList()
    {
        super(1);

        annotation = new Vector();
    }

    public AnnotationObjectList(AnnotationObjectList obj)
    {
        super(1);

        int i;

        // *** Copy the annotation field ***
        annotation = new Vector(obj.annotation.size());
        for(i = 0; i < obj.annotation.size(); ++i)
        {
            AnnotationObject newObj = (AnnotationObject)annotation.elementAt(i);
            annotation.addElement(new AnnotationObject(newObj));
        }


        SelectAll();
    }

    public boolean equals(AnnotationObjectList obj)
    {
        int i;

        boolean annotation_equal = (obj.annotation.size() == annotation.size());
        for(i = 0; (i < annotation.size()) && annotation_equal; ++i)
        {
            // Make references to AnnotationObject from Object.
            AnnotationObject annotation1 = (AnnotationObject)annotation.elementAt(i);
            AnnotationObject annotation2 = (AnnotationObject)obj.annotation.elementAt(i);
            annotation_equal = annotation1.equals(annotation2);
        }

        // Create the return value
        return (annotation_equal);
    }

    // Property setting methods
    // Property getting methods
    public Vector GetAnnotation() { return annotation; }

    // Write and read methods.
    public void WriteAtts(CommunicationBuffer buf)
    {
        if(WriteSelect(0, buf))
        {
            buf.WriteInt(annotation.size());
            for(int i = 0; i < annotation.size(); ++i)
            {
                AnnotationObject tmp = (AnnotationObject)annotation.elementAt(i);
                tmp.Write(buf);
            }
        }
    }

    public void ReadAtts(int n, CommunicationBuffer buf)
    {
        buf.ReadByte();
        {
            int len = buf.ReadInt();
            annotation.clear();
            for(int j = 0; j < len; ++j)
            {
                AnnotationObject tmp = new AnnotationObject();
                tmp.Read(buf);
                annotation.addElement(tmp);
            }
        }
        Select(0);
    }

    // Attributegroup convenience methods
    public void AddAnnotationObject(AnnotationObject obj)
    {
        annotation.addElement(new AnnotationObject(obj));
        Select(0);
    }

    public void ClearAnnotationObjects()
    {
        annotation.clear();
        Select(0);
    }

    public void RemoveAnnotationObject(int index)
    {
        if(index >= 0 && index < annotation.size())
        {
            annotation.remove(index);
            Select(0);
        }
    }

    public int GetNumAnnotationObjects()
    {
        return annotation.size();
    }

    public AnnotationObject GetAnnotationObject(int i)
    {
        AnnotationObject tmp = (AnnotationObject)annotation.elementAt(i);
        return tmp;
    }


    // Attributes
    private Vector annotation; // vector of AnnotationObject objects
}

