package llnl.visit;


// ****************************************************************************
// Class: AnnotationAttributes
//
// Purpose:
//    This class contains the attributes controlling annotations.
//
// Notes:      Autogenerated by xml2java.
//
// Programmer: xml2java
// Creation:   Thu May 27 11:02:22 PDT 2004
//
// Modifications:
//   
// ****************************************************************************

public class AnnotationAttributes extends AttributeSubject
{
    // Constants
    public final static int TICKS_OFF = 0;
    public final static int TICKS_BOTTOM = 1;
    public final static int TICKS_LEFT = 2;
    public final static int TICKS_BOTTOMLEFT = 3;
    public final static int TICKS_ALL = 4;

    public final static int LOCATION_INSIDE = 0;
    public final static int LOCATION_OUTSIDE = 1;
    public final static int LOCATION_BOTH = 2;

    public final static int AXES_CLOSESTTRIAD = 0;
    public final static int AXES_FURTHESTTRIAD = 1;
    public final static int AXES_OUTSIDEEDGES = 2;
    public final static int AXES_STATICTRIAD = 3;
    public final static int AXES_STATICEDGES = 4;

    public final static int GRADIENTSTYLE_TOPTOBOTTOM = 0;
    public final static int GRADIENTSTYLE_BOTTOMTOTOP = 1;
    public final static int GRADIENTSTYLE_LEFTTORIGHT = 2;
    public final static int GRADIENTSTYLE_RIGHTTOLEFT = 3;
    public final static int GRADIENTSTYLE_RADIAL = 4;

    public final static int BACKGROUNDMODE_SOLID = 0;
    public final static int BACKGROUNDMODE_GRADIENT = 1;


    public AnnotationAttributes()
    {
        super(75);

        axesFlag2D = true;
        axesAutoSetTicks2D = true;
        labelAutoSetScaling2D = true;
        xAxisLabels2D = true;
        yAxisLabels2D = true;
        xAxisTitle2D = true;
        yAxisTitle2D = true;
        xGridLines2D = false;
        yGridLines2D = false;
        xMajorTickMinimum2D = 0;
        yMajorTickMinimum2D = 0;
        xMajorTickMaximum2D = 1;
        yMajorTickMaximum2D = 1;
        xMajorTickSpacing2D = 0.2;
        yMajorTickSpacing2D = 0.2;
        xMinorTickSpacing2D = 0.02;
        yMinorTickSpacing2D = 0.02;
        xLabelFontHeight2D = 0.02;
        yLabelFontHeight2D = 0.02;
        xTitleFontHeight2D = 0.02;
        yTitleFontHeight2D = 0.02;
        xLabelScaling2D = 0;
        yLabelScaling2D = 0;
        axesLineWidth2D = 0;
        axesTickLocation2D = LOCATION_OUTSIDE;
        axesTicks2D = TICKS_BOTTOMLEFT;
        axesFlag = true;
        axesAutoSetTicks = true;
        labelAutoSetScaling = true;
        xAxisLabels = true;
        yAxisLabels = true;
        zAxisLabels = true;
        xAxisTitle = true;
        yAxisTitle = true;
        zAxisTitle = true;
        xGridLines = false;
        yGridLines = false;
        zGridLines = false;
        xAxisTicks = true;
        yAxisTicks = true;
        zAxisTicks = true;
        xMajorTickMinimum = 0;
        yMajorTickMinimum = 0;
        zMajorTickMinimum = 0;
        xMajorTickMaximum = 1;
        yMajorTickMaximum = 1;
        zMajorTickMaximum = 1;
        xMajorTickSpacing = 0.2;
        yMajorTickSpacing = 0.2;
        zMajorTickSpacing = 0.2;
        xMinorTickSpacing = 0.02;
        yMinorTickSpacing = 0.02;
        zMinorTickSpacing = 0.02;
        xLabelFontHeight = 0.02;
        yLabelFontHeight = 0.02;
        zLabelFontHeight = 0.02;
        xTitleFontHeight = 0.02;
        yTitleFontHeight = 0.02;
        zTitleFontHeight = 0.02;
        xLabelScaling = 0;
        yLabelScaling = 0;
        zLabelScaling = 0;
        axesTickLocation = LOCATION_INSIDE;
        axesType = AXES_CLOSESTTRIAD;
        triadFlag = true;
        bboxFlag = true;
        backgroundColor = new ColorAttribute(255, 255, 255);
        foregroundColor = new ColorAttribute(0, 0, 0);
        gradientBackgroundStyle = GRADIENTSTYLE_RADIAL;
        gradientColor1 = new ColorAttribute(0, 0, 255);
        gradientColor2 = new ColorAttribute(0, 0, 0);
        backgroundMode = BACKGROUNDMODE_SOLID;
        userInfoFlag = true;
        databaseInfoFlag = true;
        legendInfoFlag = true;
    }

    public AnnotationAttributes(AnnotationAttributes obj)
    {
        super(75);

        axesFlag2D = obj.axesFlag2D;
        axesAutoSetTicks2D = obj.axesAutoSetTicks2D;
        labelAutoSetScaling2D = obj.labelAutoSetScaling2D;
        xAxisLabels2D = obj.xAxisLabels2D;
        yAxisLabels2D = obj.yAxisLabels2D;
        xAxisTitle2D = obj.xAxisTitle2D;
        yAxisTitle2D = obj.yAxisTitle2D;
        xGridLines2D = obj.xGridLines2D;
        yGridLines2D = obj.yGridLines2D;
        xMajorTickMinimum2D = obj.xMajorTickMinimum2D;
        yMajorTickMinimum2D = obj.yMajorTickMinimum2D;
        xMajorTickMaximum2D = obj.xMajorTickMaximum2D;
        yMajorTickMaximum2D = obj.yMajorTickMaximum2D;
        xMajorTickSpacing2D = obj.xMajorTickSpacing2D;
        yMajorTickSpacing2D = obj.yMajorTickSpacing2D;
        xMinorTickSpacing2D = obj.xMinorTickSpacing2D;
        yMinorTickSpacing2D = obj.yMinorTickSpacing2D;
        xLabelFontHeight2D = obj.xLabelFontHeight2D;
        yLabelFontHeight2D = obj.yLabelFontHeight2D;
        xTitleFontHeight2D = obj.xTitleFontHeight2D;
        yTitleFontHeight2D = obj.yTitleFontHeight2D;
        xLabelScaling2D = obj.xLabelScaling2D;
        yLabelScaling2D = obj.yLabelScaling2D;
        axesLineWidth2D = obj.axesLineWidth2D;
        axesTickLocation2D = obj.axesTickLocation2D;
        axesTicks2D = obj.axesTicks2D;
        axesFlag = obj.axesFlag;
        axesAutoSetTicks = obj.axesAutoSetTicks;
        labelAutoSetScaling = obj.labelAutoSetScaling;
        xAxisLabels = obj.xAxisLabels;
        yAxisLabels = obj.yAxisLabels;
        zAxisLabels = obj.zAxisLabels;
        xAxisTitle = obj.xAxisTitle;
        yAxisTitle = obj.yAxisTitle;
        zAxisTitle = obj.zAxisTitle;
        xGridLines = obj.xGridLines;
        yGridLines = obj.yGridLines;
        zGridLines = obj.zGridLines;
        xAxisTicks = obj.xAxisTicks;
        yAxisTicks = obj.yAxisTicks;
        zAxisTicks = obj.zAxisTicks;
        xMajorTickMinimum = obj.xMajorTickMinimum;
        yMajorTickMinimum = obj.yMajorTickMinimum;
        zMajorTickMinimum = obj.zMajorTickMinimum;
        xMajorTickMaximum = obj.xMajorTickMaximum;
        yMajorTickMaximum = obj.yMajorTickMaximum;
        zMajorTickMaximum = obj.zMajorTickMaximum;
        xMajorTickSpacing = obj.xMajorTickSpacing;
        yMajorTickSpacing = obj.yMajorTickSpacing;
        zMajorTickSpacing = obj.zMajorTickSpacing;
        xMinorTickSpacing = obj.xMinorTickSpacing;
        yMinorTickSpacing = obj.yMinorTickSpacing;
        zMinorTickSpacing = obj.zMinorTickSpacing;
        xLabelFontHeight = obj.xLabelFontHeight;
        yLabelFontHeight = obj.yLabelFontHeight;
        zLabelFontHeight = obj.zLabelFontHeight;
        xTitleFontHeight = obj.xTitleFontHeight;
        yTitleFontHeight = obj.yTitleFontHeight;
        zTitleFontHeight = obj.zTitleFontHeight;
        xLabelScaling = obj.xLabelScaling;
        yLabelScaling = obj.yLabelScaling;
        zLabelScaling = obj.zLabelScaling;
        axesTickLocation = obj.axesTickLocation;
        axesType = obj.axesType;
        triadFlag = obj.triadFlag;
        bboxFlag = obj.bboxFlag;
        backgroundColor = new ColorAttribute(obj.backgroundColor);
        foregroundColor = new ColorAttribute(obj.foregroundColor);
        gradientBackgroundStyle = obj.gradientBackgroundStyle;
        gradientColor1 = new ColorAttribute(obj.gradientColor1);
        gradientColor2 = new ColorAttribute(obj.gradientColor2);
        backgroundMode = obj.backgroundMode;
        userInfoFlag = obj.userInfoFlag;
        databaseInfoFlag = obj.databaseInfoFlag;
        legendInfoFlag = obj.legendInfoFlag;

        SelectAll();
    }

    public boolean equals(AnnotationAttributes obj)
    {
        // Create the return value
        return ((axesFlag2D == obj.axesFlag2D) &&
                (axesAutoSetTicks2D == obj.axesAutoSetTicks2D) &&
                (labelAutoSetScaling2D == obj.labelAutoSetScaling2D) &&
                (xAxisLabels2D == obj.xAxisLabels2D) &&
                (yAxisLabels2D == obj.yAxisLabels2D) &&
                (xAxisTitle2D == obj.xAxisTitle2D) &&
                (yAxisTitle2D == obj.yAxisTitle2D) &&
                (xGridLines2D == obj.xGridLines2D) &&
                (yGridLines2D == obj.yGridLines2D) &&
                (xMajorTickMinimum2D == obj.xMajorTickMinimum2D) &&
                (yMajorTickMinimum2D == obj.yMajorTickMinimum2D) &&
                (xMajorTickMaximum2D == obj.xMajorTickMaximum2D) &&
                (yMajorTickMaximum2D == obj.yMajorTickMaximum2D) &&
                (xMajorTickSpacing2D == obj.xMajorTickSpacing2D) &&
                (yMajorTickSpacing2D == obj.yMajorTickSpacing2D) &&
                (xMinorTickSpacing2D == obj.xMinorTickSpacing2D) &&
                (yMinorTickSpacing2D == obj.yMinorTickSpacing2D) &&
                (xLabelFontHeight2D == obj.xLabelFontHeight2D) &&
                (yLabelFontHeight2D == obj.yLabelFontHeight2D) &&
                (xTitleFontHeight2D == obj.xTitleFontHeight2D) &&
                (yTitleFontHeight2D == obj.yTitleFontHeight2D) &&
                (xLabelScaling2D == obj.xLabelScaling2D) &&
                (yLabelScaling2D == obj.yLabelScaling2D) &&
                (axesLineWidth2D == obj.axesLineWidth2D) &&
                (axesTickLocation2D == obj.axesTickLocation2D) &&
                (axesTicks2D == obj.axesTicks2D) &&
                (axesFlag == obj.axesFlag) &&
                (axesAutoSetTicks == obj.axesAutoSetTicks) &&
                (labelAutoSetScaling == obj.labelAutoSetScaling) &&
                (xAxisLabels == obj.xAxisLabels) &&
                (yAxisLabels == obj.yAxisLabels) &&
                (zAxisLabels == obj.zAxisLabels) &&
                (xAxisTitle == obj.xAxisTitle) &&
                (yAxisTitle == obj.yAxisTitle) &&
                (zAxisTitle == obj.zAxisTitle) &&
                (xGridLines == obj.xGridLines) &&
                (yGridLines == obj.yGridLines) &&
                (zGridLines == obj.zGridLines) &&
                (xAxisTicks == obj.xAxisTicks) &&
                (yAxisTicks == obj.yAxisTicks) &&
                (zAxisTicks == obj.zAxisTicks) &&
                (xMajorTickMinimum == obj.xMajorTickMinimum) &&
                (yMajorTickMinimum == obj.yMajorTickMinimum) &&
                (zMajorTickMinimum == obj.zMajorTickMinimum) &&
                (xMajorTickMaximum == obj.xMajorTickMaximum) &&
                (yMajorTickMaximum == obj.yMajorTickMaximum) &&
                (zMajorTickMaximum == obj.zMajorTickMaximum) &&
                (xMajorTickSpacing == obj.xMajorTickSpacing) &&
                (yMajorTickSpacing == obj.yMajorTickSpacing) &&
                (zMajorTickSpacing == obj.zMajorTickSpacing) &&
                (xMinorTickSpacing == obj.xMinorTickSpacing) &&
                (yMinorTickSpacing == obj.yMinorTickSpacing) &&
                (zMinorTickSpacing == obj.zMinorTickSpacing) &&
                (xLabelFontHeight == obj.xLabelFontHeight) &&
                (yLabelFontHeight == obj.yLabelFontHeight) &&
                (zLabelFontHeight == obj.zLabelFontHeight) &&
                (xTitleFontHeight == obj.xTitleFontHeight) &&
                (yTitleFontHeight == obj.yTitleFontHeight) &&
                (zTitleFontHeight == obj.zTitleFontHeight) &&
                (xLabelScaling == obj.xLabelScaling) &&
                (yLabelScaling == obj.yLabelScaling) &&
                (zLabelScaling == obj.zLabelScaling) &&
                (axesTickLocation == obj.axesTickLocation) &&
                (axesType == obj.axesType) &&
                (triadFlag == obj.triadFlag) &&
                (bboxFlag == obj.bboxFlag) &&
                (backgroundColor == obj.backgroundColor) &&
                (foregroundColor == obj.foregroundColor) &&
                (gradientBackgroundStyle == obj.gradientBackgroundStyle) &&
                (gradientColor1 == obj.gradientColor1) &&
                (gradientColor2 == obj.gradientColor2) &&
                (backgroundMode == obj.backgroundMode) &&
                (userInfoFlag == obj.userInfoFlag) &&
                (databaseInfoFlag == obj.databaseInfoFlag) &&
                (legendInfoFlag == obj.legendInfoFlag));
    }

    // Property setting methods
    public void SetAxesFlag2D(boolean axesFlag2D_)
    {
        axesFlag2D = axesFlag2D_;
        Select(0);
    }

    public void SetAxesAutoSetTicks2D(boolean axesAutoSetTicks2D_)
    {
        axesAutoSetTicks2D = axesAutoSetTicks2D_;
        Select(1);
    }

    public void SetLabelAutoSetScaling2D(boolean labelAutoSetScaling2D_)
    {
        labelAutoSetScaling2D = labelAutoSetScaling2D_;
        Select(2);
    }

    public void SetXAxisLabels2D(boolean xAxisLabels2D_)
    {
        xAxisLabels2D = xAxisLabels2D_;
        Select(3);
    }

    public void SetYAxisLabels2D(boolean yAxisLabels2D_)
    {
        yAxisLabels2D = yAxisLabels2D_;
        Select(4);
    }

    public void SetXAxisTitle2D(boolean xAxisTitle2D_)
    {
        xAxisTitle2D = xAxisTitle2D_;
        Select(5);
    }

    public void SetYAxisTitle2D(boolean yAxisTitle2D_)
    {
        yAxisTitle2D = yAxisTitle2D_;
        Select(6);
    }

    public void SetXGridLines2D(boolean xGridLines2D_)
    {
        xGridLines2D = xGridLines2D_;
        Select(7);
    }

    public void SetYGridLines2D(boolean yGridLines2D_)
    {
        yGridLines2D = yGridLines2D_;
        Select(8);
    }

    public void SetXMajorTickMinimum2D(double xMajorTickMinimum2D_)
    {
        xMajorTickMinimum2D = xMajorTickMinimum2D_;
        Select(9);
    }

    public void SetYMajorTickMinimum2D(double yMajorTickMinimum2D_)
    {
        yMajorTickMinimum2D = yMajorTickMinimum2D_;
        Select(10);
    }

    public void SetXMajorTickMaximum2D(double xMajorTickMaximum2D_)
    {
        xMajorTickMaximum2D = xMajorTickMaximum2D_;
        Select(11);
    }

    public void SetYMajorTickMaximum2D(double yMajorTickMaximum2D_)
    {
        yMajorTickMaximum2D = yMajorTickMaximum2D_;
        Select(12);
    }

    public void SetXMajorTickSpacing2D(double xMajorTickSpacing2D_)
    {
        xMajorTickSpacing2D = xMajorTickSpacing2D_;
        Select(13);
    }

    public void SetYMajorTickSpacing2D(double yMajorTickSpacing2D_)
    {
        yMajorTickSpacing2D = yMajorTickSpacing2D_;
        Select(14);
    }

    public void SetXMinorTickSpacing2D(double xMinorTickSpacing2D_)
    {
        xMinorTickSpacing2D = xMinorTickSpacing2D_;
        Select(15);
    }

    public void SetYMinorTickSpacing2D(double yMinorTickSpacing2D_)
    {
        yMinorTickSpacing2D = yMinorTickSpacing2D_;
        Select(16);
    }

    public void SetXLabelFontHeight2D(double xLabelFontHeight2D_)
    {
        xLabelFontHeight2D = xLabelFontHeight2D_;
        Select(17);
    }

    public void SetYLabelFontHeight2D(double yLabelFontHeight2D_)
    {
        yLabelFontHeight2D = yLabelFontHeight2D_;
        Select(18);
    }

    public void SetXTitleFontHeight2D(double xTitleFontHeight2D_)
    {
        xTitleFontHeight2D = xTitleFontHeight2D_;
        Select(19);
    }

    public void SetYTitleFontHeight2D(double yTitleFontHeight2D_)
    {
        yTitleFontHeight2D = yTitleFontHeight2D_;
        Select(20);
    }

    public void SetXLabelScaling2D(int xLabelScaling2D_)
    {
        xLabelScaling2D = xLabelScaling2D_;
        Select(21);
    }

    public void SetYLabelScaling2D(int yLabelScaling2D_)
    {
        yLabelScaling2D = yLabelScaling2D_;
        Select(22);
    }

    public void SetAxesLineWidth2D(int axesLineWidth2D_)
    {
        axesLineWidth2D = axesLineWidth2D_;
        Select(23);
    }

    public void SetAxesTickLocation2D(int axesTickLocation2D_)
    {
        axesTickLocation2D = axesTickLocation2D_;
        Select(24);
    }

    public void SetAxesTicks2D(int axesTicks2D_)
    {
        axesTicks2D = axesTicks2D_;
        Select(25);
    }

    public void SetAxesFlag(boolean axesFlag_)
    {
        axesFlag = axesFlag_;
        Select(26);
    }

    public void SetAxesAutoSetTicks(boolean axesAutoSetTicks_)
    {
        axesAutoSetTicks = axesAutoSetTicks_;
        Select(27);
    }

    public void SetLabelAutoSetScaling(boolean labelAutoSetScaling_)
    {
        labelAutoSetScaling = labelAutoSetScaling_;
        Select(28);
    }

    public void SetXAxisLabels(boolean xAxisLabels_)
    {
        xAxisLabels = xAxisLabels_;
        Select(29);
    }

    public void SetYAxisLabels(boolean yAxisLabels_)
    {
        yAxisLabels = yAxisLabels_;
        Select(30);
    }

    public void SetZAxisLabels(boolean zAxisLabels_)
    {
        zAxisLabels = zAxisLabels_;
        Select(31);
    }

    public void SetXAxisTitle(boolean xAxisTitle_)
    {
        xAxisTitle = xAxisTitle_;
        Select(32);
    }

    public void SetYAxisTitle(boolean yAxisTitle_)
    {
        yAxisTitle = yAxisTitle_;
        Select(33);
    }

    public void SetZAxisTitle(boolean zAxisTitle_)
    {
        zAxisTitle = zAxisTitle_;
        Select(34);
    }

    public void SetXGridLines(boolean xGridLines_)
    {
        xGridLines = xGridLines_;
        Select(35);
    }

    public void SetYGridLines(boolean yGridLines_)
    {
        yGridLines = yGridLines_;
        Select(36);
    }

    public void SetZGridLines(boolean zGridLines_)
    {
        zGridLines = zGridLines_;
        Select(37);
    }

    public void SetXAxisTicks(boolean xAxisTicks_)
    {
        xAxisTicks = xAxisTicks_;
        Select(38);
    }

    public void SetYAxisTicks(boolean yAxisTicks_)
    {
        yAxisTicks = yAxisTicks_;
        Select(39);
    }

    public void SetZAxisTicks(boolean zAxisTicks_)
    {
        zAxisTicks = zAxisTicks_;
        Select(40);
    }

    public void SetXMajorTickMinimum(double xMajorTickMinimum_)
    {
        xMajorTickMinimum = xMajorTickMinimum_;
        Select(41);
    }

    public void SetYMajorTickMinimum(double yMajorTickMinimum_)
    {
        yMajorTickMinimum = yMajorTickMinimum_;
        Select(42);
    }

    public void SetZMajorTickMinimum(double zMajorTickMinimum_)
    {
        zMajorTickMinimum = zMajorTickMinimum_;
        Select(43);
    }

    public void SetXMajorTickMaximum(double xMajorTickMaximum_)
    {
        xMajorTickMaximum = xMajorTickMaximum_;
        Select(44);
    }

    public void SetYMajorTickMaximum(double yMajorTickMaximum_)
    {
        yMajorTickMaximum = yMajorTickMaximum_;
        Select(45);
    }

    public void SetZMajorTickMaximum(double zMajorTickMaximum_)
    {
        zMajorTickMaximum = zMajorTickMaximum_;
        Select(46);
    }

    public void SetXMajorTickSpacing(double xMajorTickSpacing_)
    {
        xMajorTickSpacing = xMajorTickSpacing_;
        Select(47);
    }

    public void SetYMajorTickSpacing(double yMajorTickSpacing_)
    {
        yMajorTickSpacing = yMajorTickSpacing_;
        Select(48);
    }

    public void SetZMajorTickSpacing(double zMajorTickSpacing_)
    {
        zMajorTickSpacing = zMajorTickSpacing_;
        Select(49);
    }

    public void SetXMinorTickSpacing(double xMinorTickSpacing_)
    {
        xMinorTickSpacing = xMinorTickSpacing_;
        Select(50);
    }

    public void SetYMinorTickSpacing(double yMinorTickSpacing_)
    {
        yMinorTickSpacing = yMinorTickSpacing_;
        Select(51);
    }

    public void SetZMinorTickSpacing(double zMinorTickSpacing_)
    {
        zMinorTickSpacing = zMinorTickSpacing_;
        Select(52);
    }

    public void SetXLabelFontHeight(double xLabelFontHeight_)
    {
        xLabelFontHeight = xLabelFontHeight_;
        Select(53);
    }

    public void SetYLabelFontHeight(double yLabelFontHeight_)
    {
        yLabelFontHeight = yLabelFontHeight_;
        Select(54);
    }

    public void SetZLabelFontHeight(double zLabelFontHeight_)
    {
        zLabelFontHeight = zLabelFontHeight_;
        Select(55);
    }

    public void SetXTitleFontHeight(double xTitleFontHeight_)
    {
        xTitleFontHeight = xTitleFontHeight_;
        Select(56);
    }

    public void SetYTitleFontHeight(double yTitleFontHeight_)
    {
        yTitleFontHeight = yTitleFontHeight_;
        Select(57);
    }

    public void SetZTitleFontHeight(double zTitleFontHeight_)
    {
        zTitleFontHeight = zTitleFontHeight_;
        Select(58);
    }

    public void SetXLabelScaling(int xLabelScaling_)
    {
        xLabelScaling = xLabelScaling_;
        Select(59);
    }

    public void SetYLabelScaling(int yLabelScaling_)
    {
        yLabelScaling = yLabelScaling_;
        Select(60);
    }

    public void SetZLabelScaling(int zLabelScaling_)
    {
        zLabelScaling = zLabelScaling_;
        Select(61);
    }

    public void SetAxesTickLocation(int axesTickLocation_)
    {
        axesTickLocation = axesTickLocation_;
        Select(62);
    }

    public void SetAxesType(int axesType_)
    {
        axesType = axesType_;
        Select(63);
    }

    public void SetTriadFlag(boolean triadFlag_)
    {
        triadFlag = triadFlag_;
        Select(64);
    }

    public void SetBboxFlag(boolean bboxFlag_)
    {
        bboxFlag = bboxFlag_;
        Select(65);
    }

    public void SetBackgroundColor(ColorAttribute backgroundColor_)
    {
        backgroundColor = backgroundColor_;
        Select(66);
    }

    public void SetForegroundColor(ColorAttribute foregroundColor_)
    {
        foregroundColor = foregroundColor_;
        Select(67);
    }

    public void SetGradientBackgroundStyle(int gradientBackgroundStyle_)
    {
        gradientBackgroundStyle = gradientBackgroundStyle_;
        Select(68);
    }

    public void SetGradientColor1(ColorAttribute gradientColor1_)
    {
        gradientColor1 = gradientColor1_;
        Select(69);
    }

    public void SetGradientColor2(ColorAttribute gradientColor2_)
    {
        gradientColor2 = gradientColor2_;
        Select(70);
    }

    public void SetBackgroundMode(int backgroundMode_)
    {
        backgroundMode = backgroundMode_;
        Select(71);
    }

    public void SetUserInfoFlag(boolean userInfoFlag_)
    {
        userInfoFlag = userInfoFlag_;
        Select(72);
    }

    public void SetDatabaseInfoFlag(boolean databaseInfoFlag_)
    {
        databaseInfoFlag = databaseInfoFlag_;
        Select(73);
    }

    public void SetLegendInfoFlag(boolean legendInfoFlag_)
    {
        legendInfoFlag = legendInfoFlag_;
        Select(74);
    }

    // Property getting methods
    public boolean        GetAxesFlag2D() { return axesFlag2D; }
    public boolean        GetAxesAutoSetTicks2D() { return axesAutoSetTicks2D; }
    public boolean        GetLabelAutoSetScaling2D() { return labelAutoSetScaling2D; }
    public boolean        GetXAxisLabels2D() { return xAxisLabels2D; }
    public boolean        GetYAxisLabels2D() { return yAxisLabels2D; }
    public boolean        GetXAxisTitle2D() { return xAxisTitle2D; }
    public boolean        GetYAxisTitle2D() { return yAxisTitle2D; }
    public boolean        GetXGridLines2D() { return xGridLines2D; }
    public boolean        GetYGridLines2D() { return yGridLines2D; }
    public double         GetXMajorTickMinimum2D() { return xMajorTickMinimum2D; }
    public double         GetYMajorTickMinimum2D() { return yMajorTickMinimum2D; }
    public double         GetXMajorTickMaximum2D() { return xMajorTickMaximum2D; }
    public double         GetYMajorTickMaximum2D() { return yMajorTickMaximum2D; }
    public double         GetXMajorTickSpacing2D() { return xMajorTickSpacing2D; }
    public double         GetYMajorTickSpacing2D() { return yMajorTickSpacing2D; }
    public double         GetXMinorTickSpacing2D() { return xMinorTickSpacing2D; }
    public double         GetYMinorTickSpacing2D() { return yMinorTickSpacing2D; }
    public double         GetXLabelFontHeight2D() { return xLabelFontHeight2D; }
    public double         GetYLabelFontHeight2D() { return yLabelFontHeight2D; }
    public double         GetXTitleFontHeight2D() { return xTitleFontHeight2D; }
    public double         GetYTitleFontHeight2D() { return yTitleFontHeight2D; }
    public int            GetXLabelScaling2D() { return xLabelScaling2D; }
    public int            GetYLabelScaling2D() { return yLabelScaling2D; }
    public int            GetAxesLineWidth2D() { return axesLineWidth2D; }
    public int            GetAxesTickLocation2D() { return axesTickLocation2D; }
    public int            GetAxesTicks2D() { return axesTicks2D; }
    public boolean        GetAxesFlag() { return axesFlag; }
    public boolean        GetAxesAutoSetTicks() { return axesAutoSetTicks; }
    public boolean        GetLabelAutoSetScaling() { return labelAutoSetScaling; }
    public boolean        GetXAxisLabels() { return xAxisLabels; }
    public boolean        GetYAxisLabels() { return yAxisLabels; }
    public boolean        GetZAxisLabels() { return zAxisLabels; }
    public boolean        GetXAxisTitle() { return xAxisTitle; }
    public boolean        GetYAxisTitle() { return yAxisTitle; }
    public boolean        GetZAxisTitle() { return zAxisTitle; }
    public boolean        GetXGridLines() { return xGridLines; }
    public boolean        GetYGridLines() { return yGridLines; }
    public boolean        GetZGridLines() { return zGridLines; }
    public boolean        GetXAxisTicks() { return xAxisTicks; }
    public boolean        GetYAxisTicks() { return yAxisTicks; }
    public boolean        GetZAxisTicks() { return zAxisTicks; }
    public double         GetXMajorTickMinimum() { return xMajorTickMinimum; }
    public double         GetYMajorTickMinimum() { return yMajorTickMinimum; }
    public double         GetZMajorTickMinimum() { return zMajorTickMinimum; }
    public double         GetXMajorTickMaximum() { return xMajorTickMaximum; }
    public double         GetYMajorTickMaximum() { return yMajorTickMaximum; }
    public double         GetZMajorTickMaximum() { return zMajorTickMaximum; }
    public double         GetXMajorTickSpacing() { return xMajorTickSpacing; }
    public double         GetYMajorTickSpacing() { return yMajorTickSpacing; }
    public double         GetZMajorTickSpacing() { return zMajorTickSpacing; }
    public double         GetXMinorTickSpacing() { return xMinorTickSpacing; }
    public double         GetYMinorTickSpacing() { return yMinorTickSpacing; }
    public double         GetZMinorTickSpacing() { return zMinorTickSpacing; }
    public double         GetXLabelFontHeight() { return xLabelFontHeight; }
    public double         GetYLabelFontHeight() { return yLabelFontHeight; }
    public double         GetZLabelFontHeight() { return zLabelFontHeight; }
    public double         GetXTitleFontHeight() { return xTitleFontHeight; }
    public double         GetYTitleFontHeight() { return yTitleFontHeight; }
    public double         GetZTitleFontHeight() { return zTitleFontHeight; }
    public int            GetXLabelScaling() { return xLabelScaling; }
    public int            GetYLabelScaling() { return yLabelScaling; }
    public int            GetZLabelScaling() { return zLabelScaling; }
    public int            GetAxesTickLocation() { return axesTickLocation; }
    public int            GetAxesType() { return axesType; }
    public boolean        GetTriadFlag() { return triadFlag; }
    public boolean        GetBboxFlag() { return bboxFlag; }
    public ColorAttribute GetBackgroundColor() { return backgroundColor; }
    public ColorAttribute GetForegroundColor() { return foregroundColor; }
    public int            GetGradientBackgroundStyle() { return gradientBackgroundStyle; }
    public ColorAttribute GetGradientColor1() { return gradientColor1; }
    public ColorAttribute GetGradientColor2() { return gradientColor2; }
    public int            GetBackgroundMode() { return backgroundMode; }
    public boolean        GetUserInfoFlag() { return userInfoFlag; }
    public boolean        GetDatabaseInfoFlag() { return databaseInfoFlag; }
    public boolean        GetLegendInfoFlag() { return legendInfoFlag; }

    // Write and read methods.
    public void WriteAtts(CommunicationBuffer buf)
    {
        if(WriteSelect(0, buf))
            buf.WriteBool(axesFlag2D);
        if(WriteSelect(1, buf))
            buf.WriteBool(axesAutoSetTicks2D);
        if(WriteSelect(2, buf))
            buf.WriteBool(labelAutoSetScaling2D);
        if(WriteSelect(3, buf))
            buf.WriteBool(xAxisLabels2D);
        if(WriteSelect(4, buf))
            buf.WriteBool(yAxisLabels2D);
        if(WriteSelect(5, buf))
            buf.WriteBool(xAxisTitle2D);
        if(WriteSelect(6, buf))
            buf.WriteBool(yAxisTitle2D);
        if(WriteSelect(7, buf))
            buf.WriteBool(xGridLines2D);
        if(WriteSelect(8, buf))
            buf.WriteBool(yGridLines2D);
        if(WriteSelect(9, buf))
            buf.WriteDouble(xMajorTickMinimum2D);
        if(WriteSelect(10, buf))
            buf.WriteDouble(yMajorTickMinimum2D);
        if(WriteSelect(11, buf))
            buf.WriteDouble(xMajorTickMaximum2D);
        if(WriteSelect(12, buf))
            buf.WriteDouble(yMajorTickMaximum2D);
        if(WriteSelect(13, buf))
            buf.WriteDouble(xMajorTickSpacing2D);
        if(WriteSelect(14, buf))
            buf.WriteDouble(yMajorTickSpacing2D);
        if(WriteSelect(15, buf))
            buf.WriteDouble(xMinorTickSpacing2D);
        if(WriteSelect(16, buf))
            buf.WriteDouble(yMinorTickSpacing2D);
        if(WriteSelect(17, buf))
            buf.WriteDouble(xLabelFontHeight2D);
        if(WriteSelect(18, buf))
            buf.WriteDouble(yLabelFontHeight2D);
        if(WriteSelect(19, buf))
            buf.WriteDouble(xTitleFontHeight2D);
        if(WriteSelect(20, buf))
            buf.WriteDouble(yTitleFontHeight2D);
        if(WriteSelect(21, buf))
            buf.WriteInt(xLabelScaling2D);
        if(WriteSelect(22, buf))
            buf.WriteInt(yLabelScaling2D);
        if(WriteSelect(23, buf))
            buf.WriteInt(axesLineWidth2D);
        if(WriteSelect(24, buf))
            buf.WriteInt(axesTickLocation2D);
        if(WriteSelect(25, buf))
            buf.WriteInt(axesTicks2D);
        if(WriteSelect(26, buf))
            buf.WriteBool(axesFlag);
        if(WriteSelect(27, buf))
            buf.WriteBool(axesAutoSetTicks);
        if(WriteSelect(28, buf))
            buf.WriteBool(labelAutoSetScaling);
        if(WriteSelect(29, buf))
            buf.WriteBool(xAxisLabels);
        if(WriteSelect(30, buf))
            buf.WriteBool(yAxisLabels);
        if(WriteSelect(31, buf))
            buf.WriteBool(zAxisLabels);
        if(WriteSelect(32, buf))
            buf.WriteBool(xAxisTitle);
        if(WriteSelect(33, buf))
            buf.WriteBool(yAxisTitle);
        if(WriteSelect(34, buf))
            buf.WriteBool(zAxisTitle);
        if(WriteSelect(35, buf))
            buf.WriteBool(xGridLines);
        if(WriteSelect(36, buf))
            buf.WriteBool(yGridLines);
        if(WriteSelect(37, buf))
            buf.WriteBool(zGridLines);
        if(WriteSelect(38, buf))
            buf.WriteBool(xAxisTicks);
        if(WriteSelect(39, buf))
            buf.WriteBool(yAxisTicks);
        if(WriteSelect(40, buf))
            buf.WriteBool(zAxisTicks);
        if(WriteSelect(41, buf))
            buf.WriteDouble(xMajorTickMinimum);
        if(WriteSelect(42, buf))
            buf.WriteDouble(yMajorTickMinimum);
        if(WriteSelect(43, buf))
            buf.WriteDouble(zMajorTickMinimum);
        if(WriteSelect(44, buf))
            buf.WriteDouble(xMajorTickMaximum);
        if(WriteSelect(45, buf))
            buf.WriteDouble(yMajorTickMaximum);
        if(WriteSelect(46, buf))
            buf.WriteDouble(zMajorTickMaximum);
        if(WriteSelect(47, buf))
            buf.WriteDouble(xMajorTickSpacing);
        if(WriteSelect(48, buf))
            buf.WriteDouble(yMajorTickSpacing);
        if(WriteSelect(49, buf))
            buf.WriteDouble(zMajorTickSpacing);
        if(WriteSelect(50, buf))
            buf.WriteDouble(xMinorTickSpacing);
        if(WriteSelect(51, buf))
            buf.WriteDouble(yMinorTickSpacing);
        if(WriteSelect(52, buf))
            buf.WriteDouble(zMinorTickSpacing);
        if(WriteSelect(53, buf))
            buf.WriteDouble(xLabelFontHeight);
        if(WriteSelect(54, buf))
            buf.WriteDouble(yLabelFontHeight);
        if(WriteSelect(55, buf))
            buf.WriteDouble(zLabelFontHeight);
        if(WriteSelect(56, buf))
            buf.WriteDouble(xTitleFontHeight);
        if(WriteSelect(57, buf))
            buf.WriteDouble(yTitleFontHeight);
        if(WriteSelect(58, buf))
            buf.WriteDouble(zTitleFontHeight);
        if(WriteSelect(59, buf))
            buf.WriteInt(xLabelScaling);
        if(WriteSelect(60, buf))
            buf.WriteInt(yLabelScaling);
        if(WriteSelect(61, buf))
            buf.WriteInt(zLabelScaling);
        if(WriteSelect(62, buf))
            buf.WriteInt(axesTickLocation);
        if(WriteSelect(63, buf))
            buf.WriteInt(axesType);
        if(WriteSelect(64, buf))
            buf.WriteBool(triadFlag);
        if(WriteSelect(65, buf))
            buf.WriteBool(bboxFlag);
        if(WriteSelect(66, buf))
            backgroundColor.Write(buf);
        if(WriteSelect(67, buf))
            foregroundColor.Write(buf);
        if(WriteSelect(68, buf))
            buf.WriteInt(gradientBackgroundStyle);
        if(WriteSelect(69, buf))
            gradientColor1.Write(buf);
        if(WriteSelect(70, buf))
            gradientColor2.Write(buf);
        if(WriteSelect(71, buf))
            buf.WriteInt(backgroundMode);
        if(WriteSelect(72, buf))
            buf.WriteBool(userInfoFlag);
        if(WriteSelect(73, buf))
            buf.WriteBool(databaseInfoFlag);
        if(WriteSelect(74, buf))
            buf.WriteBool(legendInfoFlag);
    }

    public void ReadAtts(int n, CommunicationBuffer buf)
    {
        for(int i = 0; i < n; ++i)
        {
            int index = (int)buf.ReadByte();
            switch(index)
            {
            case 0:
                SetAxesFlag2D(buf.ReadBool());
                break;
            case 1:
                SetAxesAutoSetTicks2D(buf.ReadBool());
                break;
            case 2:
                SetLabelAutoSetScaling2D(buf.ReadBool());
                break;
            case 3:
                SetXAxisLabels2D(buf.ReadBool());
                break;
            case 4:
                SetYAxisLabels2D(buf.ReadBool());
                break;
            case 5:
                SetXAxisTitle2D(buf.ReadBool());
                break;
            case 6:
                SetYAxisTitle2D(buf.ReadBool());
                break;
            case 7:
                SetXGridLines2D(buf.ReadBool());
                break;
            case 8:
                SetYGridLines2D(buf.ReadBool());
                break;
            case 9:
                SetXMajorTickMinimum2D(buf.ReadDouble());
                break;
            case 10:
                SetYMajorTickMinimum2D(buf.ReadDouble());
                break;
            case 11:
                SetXMajorTickMaximum2D(buf.ReadDouble());
                break;
            case 12:
                SetYMajorTickMaximum2D(buf.ReadDouble());
                break;
            case 13:
                SetXMajorTickSpacing2D(buf.ReadDouble());
                break;
            case 14:
                SetYMajorTickSpacing2D(buf.ReadDouble());
                break;
            case 15:
                SetXMinorTickSpacing2D(buf.ReadDouble());
                break;
            case 16:
                SetYMinorTickSpacing2D(buf.ReadDouble());
                break;
            case 17:
                SetXLabelFontHeight2D(buf.ReadDouble());
                break;
            case 18:
                SetYLabelFontHeight2D(buf.ReadDouble());
                break;
            case 19:
                SetXTitleFontHeight2D(buf.ReadDouble());
                break;
            case 20:
                SetYTitleFontHeight2D(buf.ReadDouble());
                break;
            case 21:
                SetXLabelScaling2D(buf.ReadInt());
                break;
            case 22:
                SetYLabelScaling2D(buf.ReadInt());
                break;
            case 23:
                SetAxesLineWidth2D(buf.ReadInt());
                break;
            case 24:
                SetAxesTickLocation2D(buf.ReadInt());
                break;
            case 25:
                SetAxesTicks2D(buf.ReadInt());
                break;
            case 26:
                SetAxesFlag(buf.ReadBool());
                break;
            case 27:
                SetAxesAutoSetTicks(buf.ReadBool());
                break;
            case 28:
                SetLabelAutoSetScaling(buf.ReadBool());
                break;
            case 29:
                SetXAxisLabels(buf.ReadBool());
                break;
            case 30:
                SetYAxisLabels(buf.ReadBool());
                break;
            case 31:
                SetZAxisLabels(buf.ReadBool());
                break;
            case 32:
                SetXAxisTitle(buf.ReadBool());
                break;
            case 33:
                SetYAxisTitle(buf.ReadBool());
                break;
            case 34:
                SetZAxisTitle(buf.ReadBool());
                break;
            case 35:
                SetXGridLines(buf.ReadBool());
                break;
            case 36:
                SetYGridLines(buf.ReadBool());
                break;
            case 37:
                SetZGridLines(buf.ReadBool());
                break;
            case 38:
                SetXAxisTicks(buf.ReadBool());
                break;
            case 39:
                SetYAxisTicks(buf.ReadBool());
                break;
            case 40:
                SetZAxisTicks(buf.ReadBool());
                break;
            case 41:
                SetXMajorTickMinimum(buf.ReadDouble());
                break;
            case 42:
                SetYMajorTickMinimum(buf.ReadDouble());
                break;
            case 43:
                SetZMajorTickMinimum(buf.ReadDouble());
                break;
            case 44:
                SetXMajorTickMaximum(buf.ReadDouble());
                break;
            case 45:
                SetYMajorTickMaximum(buf.ReadDouble());
                break;
            case 46:
                SetZMajorTickMaximum(buf.ReadDouble());
                break;
            case 47:
                SetXMajorTickSpacing(buf.ReadDouble());
                break;
            case 48:
                SetYMajorTickSpacing(buf.ReadDouble());
                break;
            case 49:
                SetZMajorTickSpacing(buf.ReadDouble());
                break;
            case 50:
                SetXMinorTickSpacing(buf.ReadDouble());
                break;
            case 51:
                SetYMinorTickSpacing(buf.ReadDouble());
                break;
            case 52:
                SetZMinorTickSpacing(buf.ReadDouble());
                break;
            case 53:
                SetXLabelFontHeight(buf.ReadDouble());
                break;
            case 54:
                SetYLabelFontHeight(buf.ReadDouble());
                break;
            case 55:
                SetZLabelFontHeight(buf.ReadDouble());
                break;
            case 56:
                SetXTitleFontHeight(buf.ReadDouble());
                break;
            case 57:
                SetYTitleFontHeight(buf.ReadDouble());
                break;
            case 58:
                SetZTitleFontHeight(buf.ReadDouble());
                break;
            case 59:
                SetXLabelScaling(buf.ReadInt());
                break;
            case 60:
                SetYLabelScaling(buf.ReadInt());
                break;
            case 61:
                SetZLabelScaling(buf.ReadInt());
                break;
            case 62:
                SetAxesTickLocation(buf.ReadInt());
                break;
            case 63:
                SetAxesType(buf.ReadInt());
                break;
            case 64:
                SetTriadFlag(buf.ReadBool());
                break;
            case 65:
                SetBboxFlag(buf.ReadBool());
                break;
            case 66:
                backgroundColor.Read(buf);
                Select(66);
                break;
            case 67:
                foregroundColor.Read(buf);
                Select(67);
                break;
            case 68:
                SetGradientBackgroundStyle(buf.ReadInt());
                break;
            case 69:
                gradientColor1.Read(buf);
                Select(69);
                break;
            case 70:
                gradientColor2.Read(buf);
                Select(70);
                break;
            case 71:
                SetBackgroundMode(buf.ReadInt());
                break;
            case 72:
                SetUserInfoFlag(buf.ReadBool());
                break;
            case 73:
                SetDatabaseInfoFlag(buf.ReadBool());
                break;
            case 74:
                SetLegendInfoFlag(buf.ReadBool());
                break;
            }
        }
    }


    // Attributes
    private boolean        axesFlag2D;
    private boolean        axesAutoSetTicks2D;
    private boolean        labelAutoSetScaling2D;
    private boolean        xAxisLabels2D;
    private boolean        yAxisLabels2D;
    private boolean        xAxisTitle2D;
    private boolean        yAxisTitle2D;
    private boolean        xGridLines2D;
    private boolean        yGridLines2D;
    private double         xMajorTickMinimum2D;
    private double         yMajorTickMinimum2D;
    private double         xMajorTickMaximum2D;
    private double         yMajorTickMaximum2D;
    private double         xMajorTickSpacing2D;
    private double         yMajorTickSpacing2D;
    private double         xMinorTickSpacing2D;
    private double         yMinorTickSpacing2D;
    private double         xLabelFontHeight2D;
    private double         yLabelFontHeight2D;
    private double         xTitleFontHeight2D;
    private double         yTitleFontHeight2D;
    private int            xLabelScaling2D;
    private int            yLabelScaling2D;
    private int            axesLineWidth2D;
    private int            axesTickLocation2D;
    private int            axesTicks2D;
    private boolean        axesFlag;
    private boolean        axesAutoSetTicks;
    private boolean        labelAutoSetScaling;
    private boolean        xAxisLabels;
    private boolean        yAxisLabels;
    private boolean        zAxisLabels;
    private boolean        xAxisTitle;
    private boolean        yAxisTitle;
    private boolean        zAxisTitle;
    private boolean        xGridLines;
    private boolean        yGridLines;
    private boolean        zGridLines;
    private boolean        xAxisTicks;
    private boolean        yAxisTicks;
    private boolean        zAxisTicks;
    private double         xMajorTickMinimum;
    private double         yMajorTickMinimum;
    private double         zMajorTickMinimum;
    private double         xMajorTickMaximum;
    private double         yMajorTickMaximum;
    private double         zMajorTickMaximum;
    private double         xMajorTickSpacing;
    private double         yMajorTickSpacing;
    private double         zMajorTickSpacing;
    private double         xMinorTickSpacing;
    private double         yMinorTickSpacing;
    private double         zMinorTickSpacing;
    private double         xLabelFontHeight;
    private double         yLabelFontHeight;
    private double         zLabelFontHeight;
    private double         xTitleFontHeight;
    private double         yTitleFontHeight;
    private double         zTitleFontHeight;
    private int            xLabelScaling;
    private int            yLabelScaling;
    private int            zLabelScaling;
    private int            axesTickLocation;
    private int            axesType;
    private boolean        triadFlag;
    private boolean        bboxFlag;
    private ColorAttribute backgroundColor;
    private ColorAttribute foregroundColor;
    private int            gradientBackgroundStyle;
    private ColorAttribute gradientColor1;
    private ColorAttribute gradientColor2;
    private int            backgroundMode;
    private boolean        userInfoFlag;
    private boolean        databaseInfoFlag;
    private boolean        legendInfoFlag;
}

