package llnl.visit;


// ****************************************************************************
// Class: AnimationAttributes
//
// Purpose:
//    This class contains the animation attributes.
//
// Notes:      Autogenerated by xml2java.
//
// Programmer: xml2java
// Creation:   Tue Oct 7 10:45:46 PDT 2003
//
// Modifications:
//   
// ****************************************************************************

public class AnimationAttributes extends AttributeSubject
{
    // Constants
    public final static int PLAYBACKMODE_LOOPING = 0;
    public final static int PLAYBACKMODE_PLAYONCE = 1;
    public final static int PLAYBACKMODE_SWING = 2;


    public AnimationAttributes()
    {
        super(3);

        pipelineCachingMode = false;
        timeout = 1;
        playbackMode = PLAYBACKMODE_LOOPING;
    }

    public AnimationAttributes(AnimationAttributes obj)
    {
        super(3);

        pipelineCachingMode = obj.pipelineCachingMode;
        timeout = obj.timeout;
        playbackMode = obj.playbackMode;

        SelectAll();
    }

    public boolean equals(AnimationAttributes obj)
    {
        // Create the return value
        return ((pipelineCachingMode == obj.pipelineCachingMode) &&
                (timeout == obj.timeout) &&
                (playbackMode == obj.playbackMode));
    }

    // Property setting methods
    public void SetPipelineCachingMode(boolean pipelineCachingMode_)
    {
        pipelineCachingMode = pipelineCachingMode_;
        Select(0);
    }

    public void SetTimeout(int timeout_)
    {
        timeout = timeout_;
        Select(1);
    }

    public void SetPlaybackMode(int playbackMode_)
    {
        playbackMode = playbackMode_;
        Select(2);
    }

    // Property getting methods
    public boolean GetPipelineCachingMode() { return pipelineCachingMode; }
    public int     GetTimeout() { return timeout; }
    public int     GetPlaybackMode() { return playbackMode; }

    // Write and read methods.
    public void WriteAtts(CommunicationBuffer buf)
    {
        if(WriteSelect(0, buf))
            buf.WriteBool(pipelineCachingMode);
        if(WriteSelect(1, buf))
            buf.WriteInt(timeout);
        if(WriteSelect(2, buf))
            buf.WriteInt(playbackMode);
    }

    public void ReadAtts(int n, CommunicationBuffer buf)
    {
        for(int i = 0; i < n; ++i)
        {
            int index = (int)buf.ReadByte();
            switch(index)
            {
            case 0:
                SetPipelineCachingMode(buf.ReadBool());
                break;
            case 1:
                SetTimeout(buf.ReadInt());
                break;
            case 2:
                SetPlaybackMode(buf.ReadInt());
                break;
            }
        }
    }


    // Attributes
    private boolean pipelineCachingMode;
    private int     timeout;
    private int     playbackMode;
}

