// ****************************************************************************
//                               WavefrontOBJPluginInfo.h
// ****************************************************************************

#ifndef WAVEFRONTOBJ_PLUGIN_INFO_H
#define WAVEFRONTOBJ_PLUGIN_INFO_H
#include <DatabasePluginInfo.h>
#include <database_plugin_exports.h>

class avtDatabase;
class avtDatabaseWriter;

// ****************************************************************************
//  Class: WavefrontOBJDatabasePluginInfo
//
//  Purpose:
//    Classes that provide all the information about the WavefrontOBJ plugin.
//    Portions are separated into pieces relevant to the appropriate
//    components of VisIt.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Tue Feb 22 14:50:41 PST 2005
//
//  Modifications:
//
// ****************************************************************************

class WavefrontOBJGeneralPluginInfo : public virtual GeneralDatabasePluginInfo
{
  public:
    virtual char *GetName() const;
    virtual char *GetVersion() const;
    virtual char *GetID() const;
    virtual bool  EnabledByDefault() const;
    virtual bool  HasWriter() const;
};

class WavefrontOBJCommonPluginInfo : public virtual CommonDatabasePluginInfo, public virtual WavefrontOBJGeneralPluginInfo
{
  public:
    virtual DatabaseType              GetDatabaseType();
    virtual std::vector<std::string>  GetDefaultExtensions();
    virtual avtDatabase              *SetupDatabase(const char * const *list,
                                                    int nList, int nBlock);
};

class WavefrontOBJMDServerPluginInfo : public virtual MDServerDatabasePluginInfo, public virtual WavefrontOBJCommonPluginInfo
{
  public:
    // this makes compilers happy... remove if we ever have functions here
    virtual void dummy();
};

class WavefrontOBJEnginePluginInfo : public virtual EngineDatabasePluginInfo, public virtual WavefrontOBJCommonPluginInfo
{
  public:
    virtual avtDatabaseWriter        *GetWriter(void);
};

#endif
