#include <WavefrontOBJPluginInfo.h>
#include <avtWavefrontOBJFileFormat.h>
#include <avtSTSDFileFormatInterface.h>
#include <avtGenericDatabase.h>

// ****************************************************************************
//  Method:  WavefrontOBJCommonPluginInfo::GetDatabaseType
//
//  Purpose:
//    Returns the type of a WavefrontOBJ database.
//
//  Programmer:  meredith -- generated by xml2info
//  Creation:    Tue Feb 22 14:50:41 PST 2005
//
// ****************************************************************************
DatabaseType
WavefrontOBJCommonPluginInfo::GetDatabaseType()
{
    return DB_TYPE_STSD;
}

// ****************************************************************************
//  Method:  WavefrontOBJCommonPluginInfo::GetDefaultExtensions
//
//  Purpose:
//    Returns the default extensions for a WavefrontOBJ database.
//
//  Programmer:  meredith -- generated by xml2info
//  Creation:    Tue Feb 22 14:50:41 PST 2005
//
// ****************************************************************************
std::vector<std::string>
WavefrontOBJCommonPluginInfo::GetDefaultExtensions()
{
    std::vector<std::string> defaultExtensions;
    defaultExtensions.push_back("obj");

    return defaultExtensions;
}

// ****************************************************************************
//  Method: WavefrontOBJCommonPluginInfo::SetUpWavefrontOBJDatabase
//
//  Purpose:
//      Sets up a WavefrontOBJ database.
//
//  Arguments:
//      list    A list of file names.
//      nList   The number of timesteps in list.
//      nBlocks The number of blocks in the list.
//
//  Returns:    A WavefrontOBJ database from list.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Tue Feb 22 14:50:41 PST 2005
//
// ****************************************************************************
avtDatabase *
WavefrontOBJCommonPluginInfo::SetupDatabase(const char *const *list,
                                   int nList, int nBlock)
{
    avtSTSDFileFormat ***ffl = new avtSTSDFileFormat**[nList];
    int nTimestep = nList / nBlock;
    for (int i = 0 ; i < nTimestep ; i++)
    {
        ffl[i] = new avtSTSDFileFormat*[nBlock];
        for (int j = 0 ; j < nBlock ; j++)
        {
            ffl[i][j] = new avtWavefrontOBJFileFormat(list[i*nBlock + j]);
        }
    }
    avtSTSDFileFormatInterface *inter 
           = new avtSTSDFileFormatInterface(ffl, nTimestep, nBlock);
    return new avtGenericDatabase(inter);
}
