// ****************************************************************************
//                               VistaPluginInfo.h
// ****************************************************************************

#ifndef VISTA_PLUGIN_INFO_H
#define VISTA_PLUGIN_INFO_H
#include <DatabasePluginInfo.h>
#include <database_plugin_exports.h>

class avtDatabase;
class avtDatabaseWriter;

// ****************************************************************************
//  Class: VistaDatabasePluginInfo
//
//  Purpose:
//    Classes that provide all the information about the Vista plugin.
//    Portions are separated into pieces relevant to the appropriate
//    components of VisIt.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Tue Feb 22 14:49:31 PST 2005
//
//  Modifications:
//
// ****************************************************************************

class VistaGeneralPluginInfo : public virtual GeneralDatabasePluginInfo
{
  public:
    virtual char *GetName() const;
    virtual char *GetVersion() const;
    virtual char *GetID() const;
    virtual bool  EnabledByDefault() const;
    virtual bool  HasWriter() const;
};

class VistaCommonPluginInfo : public virtual CommonDatabasePluginInfo, public virtual VistaGeneralPluginInfo
{
  public:
    virtual DatabaseType              GetDatabaseType();
    virtual std::vector<std::string>  GetDefaultExtensions();
    virtual avtDatabase              *SetupDatabase(const char * const *list,
                                                    int nList, int nBlock);
};

class VistaMDServerPluginInfo : public virtual MDServerDatabasePluginInfo, public virtual VistaCommonPluginInfo
{
  public:
    // this makes compilers happy... remove if we ever have functions here
    virtual void dummy();
};

class VistaEnginePluginInfo : public virtual EngineDatabasePluginInfo, public virtual VistaCommonPluginInfo
{
  public:
    virtual avtDatabaseWriter        *GetWriter(void);
};

#endif
