#include <VistaPluginInfo.h>
#include <avtVistaFileFormat.h>
#include <avtSTMDFileFormatInterface.h>
#include <avtGenericDatabase.h>

// ****************************************************************************
//  Method:  VistaCommonPluginInfo::GetDatabaseType
//
//  Purpose:
//    Returns the type of a Vista database.
//
//  Programmer:  meredith -- generated by xml2info
//  Creation:    Tue Feb 22 14:49:31 PST 2005
//
// ****************************************************************************
DatabaseType
VistaCommonPluginInfo::GetDatabaseType()
{
    return DB_TYPE_STMD;
}

// ****************************************************************************
//  Method:  VistaCommonPluginInfo::GetDefaultExtensions
//
//  Purpose:
//    Returns the default extensions for a Vista database.
//
//  Programmer:  meredith -- generated by xml2info
//  Creation:    Tue Feb 22 14:49:31 PST 2005
//
// ****************************************************************************
std::vector<std::string>
VistaCommonPluginInfo::GetDefaultExtensions()
{
    std::vector<std::string> defaultExtensions;
    defaultExtensions.push_back("vista");

    return defaultExtensions;
}

// ****************************************************************************
//  Method: VistaCommonPluginInfo::SetUpVistaDatabase
//
//  Purpose:
//      Sets up a Vista database.
//
//  Arguments:
//      list    A list of file names.
//      nList   The number of timesteps in list.
//      nBlocks The number of blocks in the list.
//
//  Returns:    A Vista database from list.
//
//  Programmer: miller -- generated by xml2info
//  Creation:   Tue Feb 17 19:19:06 PST 2004
//
//  Modifications:
//
//    Mark C. Miller, Wed Jul 14 09:37:43 PDT 2004
//    Modified to support variety of Vista file formats from different codes
//
// ****************************************************************************
avtDatabase *
VistaCommonPluginInfo::SetupDatabase(const char *const *list,
                                   int nList, int nBlock)
{
    avtDatabase *db = 0;

    //
    // Create a file format interface based on information in the files.
    //
    avtFileFormatInterface *inter =
        avtVistaFileFormat::CreateFileFormatInterface(list, nList);

    // If we created a file format interface, try creating a database.
    if (inter)
    {
        // Try and create the database using the interface that was created.
        TRY
        {
            db = new avtGenericDatabase(inter);
        }
        CATCH(VisItException)
        {
            delete inter;
            delete db;
            RETHROW;
        }
        ENDTRY
    }

    return db;

}
