// ************************************************************************* //
//                            avtViSUSFileFormat.h                           //
// ************************************************************************* //

#ifndef AVT_ViSUS_FILE_FORMAT_H
#define AVT_ViSUS_FILE_FORMAT_H

#include <visus_idx.h>

#include <database_exports.h>

#include <avtMTSDFileFormat.h>

#include <map>
#include <string>
#include <vector>

using std::map;
using std::string;
using std::vector;


// ****************************************************************************
//  Class: avtViSUSFileFormat
//
//  Purpose:
//      Reads in ViSUS files as a plugin to VisIt.
//
//  Programmer: mcmiller -- generated by xml2avt
//  Creation:   Tue Sep 14 20:37:24 PST 2004
//
// ****************************************************************************

class avtViSUSFileFormat : public avtMTSDFileFormat
{
  public:
                       avtViSUSFileFormat(const char *);
    virtual           ~avtViSUSFileFormat();

    virtual const char    *GetType(void)   { return "ViSUS"; };
    virtual void           FreeUpResources(void); 

    virtual void           GetCycles(std::vector<int> &);
    virtual void           GetTimes(std::vector<double> &);
    virtual int            GetNTimesteps(void);

    virtual vtkDataSet    *GetMesh(int, const char *);
    virtual vtkDataArray  *GetVar(int, const char *);

    virtual bool           CanCacheVariable(const char *var);

    virtual void           RegisterDataSelections(
                               const vector<avtDataSelection_p> &selList,
                               vector<bool> *selectionsApplied);

  protected:

    virtual void           PopulateDatabaseMetaData(avtDatabaseMetaData *);

  private:

    void                   SetupRectilinearCoordinates();
    void                   SetupDomainAndZoneIndexing(int *zoneCounts,
                                                      int *stepSizes,
                                                      int *startZones,
                                                      int *domCounts,
                                                      int *domIndices);

    string fileName;
    IDX_file_descriptor idxFile;

    bool useGetData3D;
    bool haveSetupCoordinates;
    bool ignoreDataSelections;

    int globalMin[3], globalMax[3];
    double origin3D[3], gridSpacing3D[3];

    int minTimeIndex, maxTimeIndex;
    vector<int> cycleVals;
    vector<double> timeVals;

    int dataDimension;

    int numFields;

    int globalZoneTotal;

    int globalZoneCount[3];

    float *globalNodeCoords[3];

    int *fieldSampleSize;

    map<string, int> fieldMap;

    int procNum;
    int procCount;

    vector<avtDataSelection_p> selList;
    vector<bool>              *selsApplied;

};


#endif
