// ****************************************************************************
//                               ViSUSPluginInfo.h
// ****************************************************************************

#ifndef VISUS_PLUGIN_INFO_H
#define VISUS_PLUGIN_INFO_H
#include <DatabasePluginInfo.h>
#include <database_plugin_exports.h>

class avtDatabase;
class avtDatabaseWriter;

// ****************************************************************************
//  Class: ViSUSDatabasePluginInfo
//
//  Purpose:
//    Classes that provide all the information about the ViSUS plugin.
//    Portions are separated into pieces relevant to the appropriate
//    components of VisIt.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Tue Feb 22 14:49:15 PST 2005
//
//  Modifications:
//
// ****************************************************************************

class ViSUSGeneralPluginInfo : public virtual GeneralDatabasePluginInfo
{
  public:
    virtual char *GetName() const;
    virtual char *GetVersion() const;
    virtual char *GetID() const;
    virtual bool  EnabledByDefault() const;
    virtual bool  HasWriter() const;
};

class ViSUSCommonPluginInfo : public virtual CommonDatabasePluginInfo, public virtual ViSUSGeneralPluginInfo
{
  public:
    virtual DatabaseType              GetDatabaseType();
    virtual std::vector<std::string>  GetDefaultExtensions();
    virtual avtDatabase              *SetupDatabase(const char * const *list,
                                                    int nList, int nBlock);
};

class ViSUSMDServerPluginInfo : public virtual MDServerDatabasePluginInfo, public virtual ViSUSCommonPluginInfo
{
  public:
    // this makes compilers happy... remove if we ever have functions here
    virtual void dummy();
};

class ViSUSEnginePluginInfo : public virtual EngineDatabasePluginInfo, public virtual ViSUSCommonPluginInfo
{
  public:
    virtual avtDatabaseWriter        *GetWriter(void);
};

#endif
