#include <ViSUSPluginInfo.h>
#include <avtViSUSFileFormat.h>
#include <avtMTSDFileFormatInterface.h>
#include <avtGenericDatabase.h>

// ****************************************************************************
//  Method:  ViSUSCommonPluginInfo::GetDatabaseType
//
//  Purpose:
//    Returns the type of a ViSUS database.
//
//  Programmer:  meredith -- generated by xml2info
//  Creation:    Tue Feb 22 14:49:15 PST 2005
//
// ****************************************************************************
DatabaseType
ViSUSCommonPluginInfo::GetDatabaseType()
{
    return DB_TYPE_MTSD;
}

// ****************************************************************************
//  Method:  ViSUSCommonPluginInfo::GetDefaultExtensions
//
//  Purpose:
//    Returns the default extensions for a ViSUS database.
//
//  Programmer:  meredith -- generated by xml2info
//  Creation:    Tue Feb 22 14:49:15 PST 2005
//
// ****************************************************************************
std::vector<std::string>
ViSUSCommonPluginInfo::GetDefaultExtensions()
{
    std::vector<std::string> defaultExtensions;
    defaultExtensions.push_back("idx");
    defaultExtensions.push_back("vis");

    return defaultExtensions;
}

// ****************************************************************************
//  Method: ViSUSCommonPluginInfo::SetUpViSUSDatabase
//
//  Purpose:
//      Sets up a ViSUS database.
//
//  Arguments:
//      list    A list of file names.
//      nList   The number of timesteps in list.
//      nBlocks The number of blocks in the list.
//
//  Returns:    A ViSUS database from list.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Tue Feb 22 14:49:15 PST 2005
//
// ****************************************************************************
avtDatabase *
ViSUSCommonPluginInfo::SetupDatabase(const char *const *list,
                                   int nList, int nBlock)
{
    avtMTSDFileFormat **ffl = new avtMTSDFileFormat*[nList];
    for (int i = 0 ; i < nList ; i++)
    {
        ffl[i] = new avtViSUSFileFormat(list[i]);
    }
    avtMTSDFileFormatInterface *inter 
           = new avtMTSDFileFormatInterface(ffl, nList);
    return new avtGenericDatabase(inter);
}
