#include <VTKPluginInfo.h>
#include <avtVTKFileFormat.h>
#include <avtSTSDFileFormatInterface.h>
#include <avtGenericDatabase.h>

// ****************************************************************************
//  Method:  VTKCommonPluginInfo::GetDatabaseType
//
//  Purpose:
//    Returns the type of a VTK database.
//
//  Programmer:  meredith -- generated by xml2info
//  Creation:    Tue Feb 22 14:48:48 PST 2005
//
// ****************************************************************************
DatabaseType
VTKCommonPluginInfo::GetDatabaseType()
{
    return DB_TYPE_STSD;
}

// ****************************************************************************
//  Method:  VTKCommonPluginInfo::GetDefaultExtensions
//
//  Purpose:
//    Returns the default extensions for a VTK database.
//
//  Programmer:  meredith -- generated by xml2info
//  Creation:    Tue Feb 22 14:48:48 PST 2005
//
// ****************************************************************************
std::vector<std::string>
VTKCommonPluginInfo::GetDefaultExtensions()
{
    std::vector<std::string> defaultExtensions;
    defaultExtensions.push_back("vtk");

    return defaultExtensions;
}

// ****************************************************************************
//  Method: VTKCommonPluginInfo::SetUpVTKDatabase
//
//  Purpose:
//      Sets up a VTK database.
//
//  Arguments:
//      list    A list of file names.
//      nList   The number of timesteps in list.
//      nBlocks The number of blocks in the list.
//
//  Returns:    A VTK database from list.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Tue Feb 22 14:48:48 PST 2005
//
// ****************************************************************************
avtDatabase *
VTKCommonPluginInfo::SetupDatabase(const char *const *list,
                                   int nList, int nBlock)
{
    avtSTSDFileFormat ***ffl = new avtSTSDFileFormat**[nList];
    int nTimestep = nList / nBlock;
    for (int i = 0 ; i < nTimestep ; i++)
    {
        ffl[i] = new avtSTSDFileFormat*[nBlock];
        for (int j = 0 ; j < nBlock ; j++)
        {
            ffl[i][j] = new avtVTKFileFormat(list[i*nBlock + j]);
        }
    }
    avtSTSDFileFormatInterface *inter 
           = new avtSTSDFileFormatInterface(ffl, nTimestep, nBlock);
    return new avtGenericDatabase(inter);
}
