#include <TimeVaryingExodusPluginInfo.h>
#include <avtTimeVaryingExodusFileFormat.h>
#include <avtSTSDFileFormatInterface.h>
#include <avtGenericDatabase.h>

// ****************************************************************************
//  Method:  TimeVaryingExodusCommonPluginInfo::GetDatabaseType
//
//  Purpose:
//    Returns the type of a TimeVaryingExodus database.
//
//  Programmer:  meredith -- generated by xml2info
//  Creation:    Tue Feb 22 14:48:28 PST 2005
//
// ****************************************************************************
DatabaseType
TimeVaryingExodusCommonPluginInfo::GetDatabaseType()
{
    return DB_TYPE_STSD;
}

// ****************************************************************************
//  Method:  TimeVaryingExodusCommonPluginInfo::GetDefaultExtensions
//
//  Purpose:
//    Returns the default extensions for a TimeVaryingExodus database.
//
//  Programmer:  meredith -- generated by xml2info
//  Creation:    Tue Feb 22 14:48:28 PST 2005
//
// ****************************************************************************
std::vector<std::string>
TimeVaryingExodusCommonPluginInfo::GetDefaultExtensions()
{
    std::vector<std::string> defaultExtensions;
    defaultExtensions.push_back("exII");

    return defaultExtensions;
}

// ****************************************************************************
//  Method: TimeVaryingExodusCommonPluginInfo::SetUpTimeVaryingExodusDatabase
//
//  Purpose:
//      Sets up a TimeVaryingExodus database.
//
//  Arguments:
//      list    A list of file names.
//      nList   The number of timesteps in list.
//      nBlocks The number of blocks in the list.
//
//  Returns:    A TimeVaryingExodus database from list.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Tue Feb 22 14:48:28 PST 2005
//
// ****************************************************************************
avtDatabase *
TimeVaryingExodusCommonPluginInfo::SetupDatabase(const char *const *list,
                                   int nList, int nBlock)
{
    avtSTSDFileFormat ***ffl = new avtSTSDFileFormat**[nList];
    int nTimestep = nList / nBlock;
    for (int i = 0 ; i < nTimestep ; i++)
    {
        ffl[i] = new avtSTSDFileFormat*[nBlock];
        for (int j = 0 ; j < nBlock ; j++)
        {
            ffl[i][j] = new avtTimeVaryingExodusFileFormat(list[i*nBlock + j]);
        }
    }
    avtSTSDFileFormatInterface *inter 
           = new avtSTSDFileFormatInterface(ffl, nTimestep, nBlock);
    return new avtGenericDatabase(inter);
}
