// ****************************************************************************
//                               TetradPluginInfo.h
// ****************************************************************************

#ifndef TETRAD_PLUGIN_INFO_H
#define TETRAD_PLUGIN_INFO_H
#include <DatabasePluginInfo.h>
#include <database_plugin_exports.h>

class avtDatabase;
class avtDatabaseWriter;

// ****************************************************************************
//  Class: TetradDatabasePluginInfo
//
//  Purpose:
//    Classes that provide all the information about the Tetrad plugin.
//    Portions are separated into pieces relevant to the appropriate
//    components of VisIt.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Tue Feb 22 14:47:59 PST 2005
//
//  Modifications:
//
// ****************************************************************************

class TetradGeneralPluginInfo : public virtual GeneralDatabasePluginInfo
{
  public:
    virtual char *GetName() const;
    virtual char *GetVersion() const;
    virtual char *GetID() const;
    virtual bool  EnabledByDefault() const;
    virtual bool  HasWriter() const;
};

class TetradCommonPluginInfo : public virtual CommonDatabasePluginInfo, public virtual TetradGeneralPluginInfo
{
  public:
    virtual DatabaseType              GetDatabaseType();
    virtual std::vector<std::string>  GetDefaultExtensions();
    virtual avtDatabase              *SetupDatabase(const char * const *list,
                                                    int nList, int nBlock);
};

class TetradMDServerPluginInfo : public virtual MDServerDatabasePluginInfo, public virtual TetradCommonPluginInfo
{
  public:
    // this makes compilers happy... remove if we ever have functions here
    virtual void dummy();
};

class TetradEnginePluginInfo : public virtual EngineDatabasePluginInfo, public virtual TetradCommonPluginInfo
{
  public:
    virtual avtDatabaseWriter        *GetWriter(void);
};

#endif
