#include <TetradPluginInfo.h>
#include <avtTetradFileFormat.h>
#include <avtMTSDFileFormatInterface.h>
#include <avtGenericDatabase.h>

// ****************************************************************************
//  Method:  TetradCommonPluginInfo::GetDatabaseType
//
//  Purpose:
//    Returns the type of a Tetrad database.
//
//  Programmer:  meredith -- generated by xml2info
//  Creation:    Tue Feb 22 14:47:59 PST 2005
//
// ****************************************************************************
DatabaseType
TetradCommonPluginInfo::GetDatabaseType()
{
    return DB_TYPE_MTSD;
}

// ****************************************************************************
//  Method:  TetradCommonPluginInfo::GetDefaultExtensions
//
//  Purpose:
//    Returns the default extensions for a Tetrad database.
//
//  Programmer:  meredith -- generated by xml2info
//  Creation:    Tue Feb 22 14:47:59 PST 2005
//
// ****************************************************************************
std::vector<std::string>
TetradCommonPluginInfo::GetDefaultExtensions()
{
    std::vector<std::string> defaultExtensions;
    defaultExtensions.push_back("h5");
    defaultExtensions.push_back("hdf5");

    return defaultExtensions;
}

// ****************************************************************************
//  Method: TetradCommonPluginInfo::SetUpTetradDatabase
//
//  Purpose:
//      Sets up a Tetrad database.
//
//  Arguments:
//      list    A list of file names.
//      nList   The number of timesteps in list.
//      nBlocks The number of blocks in the list.
//
//  Returns:    A Tetrad database from list.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Tue Feb 22 14:47:59 PST 2005
//
// ****************************************************************************
avtDatabase *
TetradCommonPluginInfo::SetupDatabase(const char *const *list,
                                   int nList, int nBlock)
{
    avtMTSDFileFormat **ffl = new avtMTSDFileFormat*[nList];
    for (int i = 0 ; i < nList ; i++)
    {
        ffl[i] = new avtTetradFileFormat(list[i]);
    }
    avtMTSDFileFormatInterface *inter 
           = new avtMTSDFileFormatInterface(ffl, nList);
    return new avtGenericDatabase(inter);
}
