// ****************************************************************************
//                               TecplotPluginInfo.h
// ****************************************************************************

#ifndef TECPLOT_PLUGIN_INFO_H
#define TECPLOT_PLUGIN_INFO_H
#include <DatabasePluginInfo.h>
#include <database_plugin_exports.h>

class avtDatabase;
class avtDatabaseWriter;

// ****************************************************************************
//  Class: TecplotDatabasePluginInfo
//
//  Purpose:
//    Classes that provide all the information about the Tecplot plugin.
//    Portions are separated into pieces relevant to the appropriate
//    components of VisIt.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Tue Feb 22 14:41:50 PST 2005
//
//  Modifications:
//
// ****************************************************************************

class TecplotGeneralPluginInfo : public virtual GeneralDatabasePluginInfo
{
  public:
    virtual char *GetName() const;
    virtual char *GetVersion() const;
    virtual char *GetID() const;
    virtual bool  EnabledByDefault() const;
    virtual bool  HasWriter() const;
};

class TecplotCommonPluginInfo : public virtual CommonDatabasePluginInfo, public virtual TecplotGeneralPluginInfo
{
  public:
    virtual DatabaseType              GetDatabaseType();
    virtual std::vector<std::string>  GetDefaultExtensions();
    virtual avtDatabase              *SetupDatabase(const char * const *list,
                                                    int nList, int nBlock);
};

class TecplotMDServerPluginInfo : public virtual MDServerDatabasePluginInfo, public virtual TecplotCommonPluginInfo
{
  public:
    // this makes compilers happy... remove if we ever have functions here
    virtual void dummy();
};

class TecplotEnginePluginInfo : public virtual EngineDatabasePluginInfo, public virtual TecplotCommonPluginInfo
{
  public:
    virtual avtDatabaseWriter        *GetWriter(void);
};

#endif
