#include <TecplotPluginInfo.h>
#include <avtTecplotFileFormat.h>
#include <avtSTMDFileFormatInterface.h>
#include <avtGenericDatabase.h>

// ****************************************************************************
//  Method:  TecplotCommonPluginInfo::GetDatabaseType
//
//  Purpose:
//    Returns the type of a Tecplot database.
//
//  Programmer:  meredith -- generated by xml2info
//  Creation:    Tue Feb 22 14:41:50 PST 2005
//
// ****************************************************************************
DatabaseType
TecplotCommonPluginInfo::GetDatabaseType()
{
    return DB_TYPE_STMD;
}

// ****************************************************************************
//  Method:  TecplotCommonPluginInfo::GetDefaultExtensions
//
//  Purpose:
//    Returns the default extensions for a Tecplot database.
//
//  Programmer:  meredith -- generated by xml2info
//  Creation:    Tue Feb 22 14:41:50 PST 2005
//
// ****************************************************************************
std::vector<std::string>
TecplotCommonPluginInfo::GetDefaultExtensions()
{
    std::vector<std::string> defaultExtensions;
    defaultExtensions.push_back("tp");
    defaultExtensions.push_back("plt");
    defaultExtensions.push_back("tec");

    return defaultExtensions;
}

// ****************************************************************************
//  Method: TecplotCommonPluginInfo::SetUpTecplotDatabase
//
//  Purpose:
//      Sets up a Tecplot database.
//
//  Arguments:
//      list    A list of file names.
//      nList   The number of timesteps in list.
//      nBlocks The number of blocks in the list.
//
//  Returns:    A Tecplot database from list.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Tue Feb 22 14:41:50 PST 2005
//
// ****************************************************************************
avtDatabase *
TecplotCommonPluginInfo::SetupDatabase(const char *const *list,
                                   int nList, int nBlock)
{
    avtSTMDFileFormat **ffl = new avtSTMDFileFormat*[nList];
    for (int i = 0 ; i < nList ; i++)
    {
        ffl[i] = new avtTecplotFileFormat(list[i]);
    }
    avtSTMDFileFormatInterface *inter 
           = new avtSTMDFileFormatInterface(ffl, nList);
    return new avtGenericDatabase(inter);
}
