// ****************************************************************************
//                               TFTPluginInfo.h
// ****************************************************************************

#ifndef TFT_PLUGIN_INFO_H
#define TFT_PLUGIN_INFO_H
#include <DatabasePluginInfo.h>
#include <database_plugin_exports.h>

class avtDatabase;
class avtDatabaseWriter;

// ****************************************************************************
//  Class: TFTDatabasePluginInfo
//
//  Purpose:
//    Classes that provide all the information about the TFT plugin.
//    Portions are separated into pieces relevant to the appropriate
//    components of VisIt.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Wed Feb 23 09:25:08 PDT 2005
//
//  Modifications:
//
// ****************************************************************************

class TFTGeneralPluginInfo : public virtual GeneralDatabasePluginInfo
{
  public:
    virtual char *GetName() const;
    virtual char *GetVersion() const;
    virtual char *GetID() const;
    virtual bool  EnabledByDefault() const;
    virtual bool  HasWriter() const;
};

class TFTCommonPluginInfo : public virtual CommonDatabasePluginInfo, public virtual TFTGeneralPluginInfo
{
  public:
    virtual DatabaseType              GetDatabaseType();
    virtual std::vector<std::string>  GetDefaultExtensions();
    virtual avtDatabase              *SetupDatabase(const char * const *list,
                                                    int nList, int nBlock);
};

class TFTMDServerPluginInfo : public virtual MDServerDatabasePluginInfo, public virtual TFTCommonPluginInfo
{
  public:
    // this makes compilers happy... remove if we ever have functions here
    virtual void dummy();
};

class TFTEnginePluginInfo : public virtual EngineDatabasePluginInfo, public virtual TFTCommonPluginInfo
{
  public:
    virtual avtDatabaseWriter        *GetWriter(void);
};

#endif
