#include <TFTPluginInfo.h>
#include <avtTFTFileFormat.h>
#include <avtSTSDFileFormatInterface.h>
#include <avtGenericDatabase.h>

// ****************************************************************************
//  Method:  TFTCommonPluginInfo::GetDatabaseType
//
//  Purpose:
//    Returns the type of a TFT database.
//
//  Programmer:  whitlocb -- generated by xml2info
//  Creation:    Wed Feb 23 09:25:08 PDT 2005
//
// ****************************************************************************
DatabaseType
TFTCommonPluginInfo::GetDatabaseType()
{
    return DB_TYPE_STSD;
}

// ****************************************************************************
//  Method:  TFTCommonPluginInfo::GetDefaultExtensions
//
//  Purpose:
//    Returns the default extensions for a TFT database.
//
//  Programmer:  whitlocb -- generated by xml2info
//  Creation:    Wed Feb 23 09:25:08 PDT 2005
//
// ****************************************************************************
std::vector<std::string>
TFTCommonPluginInfo::GetDefaultExtensions()
{
    std::vector<std::string> defaultExtensions;
    defaultExtensions.push_back("dat");
    defaultExtensions.push_back("DAT");
    defaultExtensions.push_back("Dat");
    defaultExtensions.push_back("tft");
    defaultExtensions.push_back("TFT");
    defaultExtensions.push_back("Tft");

    return defaultExtensions;
}

// ****************************************************************************
//  Method: TFTCommonPluginInfo::SetUpTFTDatabase
//
//  Purpose:
//      Sets up a TFT database.
//
//  Arguments:
//      list    A list of file names.
//      nList   The number of timesteps in list.
//      nBlocks The number of blocks in the list.
//
//  Returns:    A TFT database from list.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Wed Feb 23 09:25:08 PDT 2005
//
// ****************************************************************************
avtDatabase *
TFTCommonPluginInfo::SetupDatabase(const char *const *list,
                                   int nList, int nBlock)
{
    avtSTSDFileFormat ***ffl = new avtSTSDFileFormat**[nList];
    int nTimestep = nList / nBlock;
    for (int i = 0 ; i < nTimestep ; i++)
    {
        ffl[i] = new avtSTSDFileFormat*[nBlock];
        for (int j = 0 ; j < nBlock ; j++)
        {
            ffl[i][j] = new avtTFTFileFormat(list[i*nBlock + j]);
        }
    }
    avtSTSDFileFormatInterface *inter 
           = new avtSTSDFileFormatInterface(ffl, nTimestep, nBlock);
    return new avtGenericDatabase(inter);
}
