// ****************************************************************************
//                               SpheralPluginInfo.h
// ****************************************************************************

#ifndef SPHERAL_PLUGIN_INFO_H
#define SPHERAL_PLUGIN_INFO_H
#include <DatabasePluginInfo.h>
#include <database_plugin_exports.h>

class avtDatabase;
class avtDatabaseWriter;

// ****************************************************************************
//  Class: SpheralDatabasePluginInfo
//
//  Purpose:
//    Classes that provide all the information about the Spheral plugin.
//    Portions are separated into pieces relevant to the appropriate
//    components of VisIt.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Tue Feb 22 14:47:40 PST 2005
//
//  Modifications:
//
// ****************************************************************************

class SpheralGeneralPluginInfo : public virtual GeneralDatabasePluginInfo
{
  public:
    virtual char *GetName() const;
    virtual char *GetVersion() const;
    virtual char *GetID() const;
    virtual bool  EnabledByDefault() const;
    virtual bool  HasWriter() const;
};

class SpheralCommonPluginInfo : public virtual CommonDatabasePluginInfo, public virtual SpheralGeneralPluginInfo
{
  public:
    virtual DatabaseType              GetDatabaseType();
    virtual std::vector<std::string>  GetDefaultExtensions();
    virtual avtDatabase              *SetupDatabase(const char * const *list,
                                                    int nList, int nBlock);
};

class SpheralMDServerPluginInfo : public virtual MDServerDatabasePluginInfo, public virtual SpheralCommonPluginInfo
{
  public:
    // this makes compilers happy... remove if we ever have functions here
    virtual void dummy();
};

class SpheralEnginePluginInfo : public virtual EngineDatabasePluginInfo, public virtual SpheralCommonPluginInfo
{
  public:
    virtual avtDatabaseWriter        *GetWriter(void);
};

#endif
