#include <SpheralPluginInfo.h>
#include <avtSpheralFileFormat.h>
#include <avtSTMDFileFormatInterface.h>
#include <avtGenericDatabase.h>

// ****************************************************************************
//  Method:  SpheralCommonPluginInfo::GetDatabaseType
//
//  Purpose:
//    Returns the type of a Spheral database.
//
//  Programmer:  meredith -- generated by xml2info
//  Creation:    Tue Feb 22 14:47:40 PST 2005
//
// ****************************************************************************
DatabaseType
SpheralCommonPluginInfo::GetDatabaseType()
{
    return DB_TYPE_STMD;
}

// ****************************************************************************
//  Method:  SpheralCommonPluginInfo::GetDefaultExtensions
//
//  Purpose:
//    Returns the default extensions for a Spheral database.
//
//  Programmer:  meredith -- generated by xml2info
//  Creation:    Tue Feb 22 14:47:40 PST 2005
//
// ****************************************************************************
std::vector<std::string>
SpheralCommonPluginInfo::GetDefaultExtensions()
{
    std::vector<std::string> defaultExtensions;
    defaultExtensions.push_back("sv");
    defaultExtensions.push_back("spheral");

    return defaultExtensions;
}

// ****************************************************************************
//  Method: SpheralCommonPluginInfo::SetUpSpheralDatabase
//
//  Purpose:
//      Sets up a Spheral database.
//
//  Arguments:
//      list    A list of file names.
//      nList   The number of timesteps in list.
//      nBlocks The number of blocks in the list.
//
//  Returns:    A Spheral database from list.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Tue Feb 22 14:47:40 PST 2005
//
// ****************************************************************************
avtDatabase *
SpheralCommonPluginInfo::SetupDatabase(const char *const *list,
                                   int nList, int nBlock)
{
    avtSTMDFileFormat **ffl = new avtSTMDFileFormat*[nList];
    for (int i = 0 ; i < nList ; i++)
    {
        ffl[i] = new avtSpheralFileFormat(list[i]);
    }
    avtSTMDFileFormatInterface *inter 
           = new avtSTMDFileFormatInterface(ffl, nList);
    return new avtGenericDatabase(inter);
}
