// ****************************************************************************
//                               SiloPluginInfo.h
// ****************************************************************************

#ifndef SILO_PLUGIN_INFO_H
#define SILO_PLUGIN_INFO_H
#include <DatabasePluginInfo.h>
#include <database_plugin_exports.h>

class avtDatabase;
class avtDatabaseWriter;

// ****************************************************************************
//  Class: SiloDatabasePluginInfo
//
//  Purpose:
//    Classes that provide all the information about the Silo plugin.
//    Portions are separated into pieces relevant to the appropriate
//    components of VisIt.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Tue Feb 22 14:45:32 PST 2005
//
//  Modifications:
//
// ****************************************************************************

class SiloGeneralPluginInfo : public virtual GeneralDatabasePluginInfo
{
  public:
    virtual char *GetName() const;
    virtual char *GetVersion() const;
    virtual char *GetID() const;
    virtual bool  EnabledByDefault() const;
    virtual bool  HasWriter() const;
};

class SiloCommonPluginInfo : public virtual CommonDatabasePluginInfo, public virtual SiloGeneralPluginInfo
{
  public:
    virtual DatabaseType              GetDatabaseType();
    virtual std::vector<std::string>  GetDefaultExtensions();
    virtual avtDatabase              *SetupDatabase(const char * const *list,
                                                    int nList, int nBlock);
};

class SiloMDServerPluginInfo : public virtual MDServerDatabasePluginInfo, public virtual SiloCommonPluginInfo
{
  public:
    // this makes compilers happy... remove if we ever have functions here
    virtual void dummy();
};

class SiloEnginePluginInfo : public virtual EngineDatabasePluginInfo, public virtual SiloCommonPluginInfo
{
  public:
    virtual avtDatabaseWriter        *GetWriter(void);
};

#endif
