#include <SiloPluginInfo.h>
#include <avtSiloFileFormat.h>
#include <avtSTMDFileFormatInterface.h>
#include <avtGenericDatabase.h>

// ****************************************************************************
//  Method:  SiloCommonPluginInfo::GetDatabaseType
//
//  Purpose:
//    Returns the type of a Silo database.
//
//  Programmer:  meredith -- generated by xml2info
//  Creation:    Tue Feb 22 14:45:32 PST 2005
//
// ****************************************************************************
DatabaseType
SiloCommonPluginInfo::GetDatabaseType()
{
    return DB_TYPE_STMD;
}

// ****************************************************************************
//  Method:  SiloCommonPluginInfo::GetDefaultExtensions
//
//  Purpose:
//    Returns the default extensions for a Silo database.
//
//  Programmer:  meredith -- generated by xml2info
//  Creation:    Tue Feb 22 14:45:32 PST 2005
//
// ****************************************************************************
std::vector<std::string>
SiloCommonPluginInfo::GetDefaultExtensions()
{
    std::vector<std::string> defaultExtensions;
    defaultExtensions.push_back("silo");
    defaultExtensions.push_back("pdb");

    return defaultExtensions;
}

// ****************************************************************************
//  Method: SiloCommonPluginInfo::SetUpSiloDatabase
//
//  Purpose:
//      Sets up a Silo database.
//
//  Arguments:
//      list    A list of file names.
//      nList   The number of timesteps in list.
//      nBlocks The number of blocks in the list.
//
//  Returns:    A Silo database from list.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Tue Feb 22 14:45:32 PST 2005
//
// ****************************************************************************
avtDatabase *
SiloCommonPluginInfo::SetupDatabase(const char *const *list,
                                   int nList, int nBlock)
{
    avtSTMDFileFormat **ffl = new avtSTMDFileFormat*[nList];
    for (int i = 0 ; i < nList ; i++)
    {
        ffl[i] = new avtSiloFileFormat(list[i]);
    }
    avtSTMDFileFormatInterface *inter 
           = new avtSTMDFileFormatInterface(ffl, nList);
    return new avtGenericDatabase(inter);
}
