// ****************************************************************************
//                               STLPluginInfo.h
// ****************************************************************************

#ifndef STL_PLUGIN_INFO_H
#define STL_PLUGIN_INFO_H
#include <DatabasePluginInfo.h>
#include <database_plugin_exports.h>

class avtDatabase;
class avtDatabaseWriter;

// ****************************************************************************
//  Class: STLDatabasePluginInfo
//
//  Purpose:
//    Classes that provide all the information about the STL plugin.
//    Portions are separated into pieces relevant to the appropriate
//    components of VisIt.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Tue Feb 22 14:45:16 PST 2005
//
//  Modifications:
//
// ****************************************************************************

class STLGeneralPluginInfo : public virtual GeneralDatabasePluginInfo
{
  public:
    virtual char *GetName() const;
    virtual char *GetVersion() const;
    virtual char *GetID() const;
    virtual bool  EnabledByDefault() const;
    virtual bool  HasWriter() const;
};

class STLCommonPluginInfo : public virtual CommonDatabasePluginInfo, public virtual STLGeneralPluginInfo
{
  public:
    virtual DatabaseType              GetDatabaseType();
    virtual std::vector<std::string>  GetDefaultExtensions();
    virtual avtDatabase              *SetupDatabase(const char * const *list,
                                                    int nList, int nBlock);
};

class STLMDServerPluginInfo : public virtual MDServerDatabasePluginInfo, public virtual STLCommonPluginInfo
{
  public:
    // this makes compilers happy... remove if we ever have functions here
    virtual void dummy();
};

class STLEnginePluginInfo : public virtual EngineDatabasePluginInfo, public virtual STLCommonPluginInfo
{
  public:
    virtual avtDatabaseWriter        *GetWriter(void);
};

#endif
