#include <STLPluginInfo.h>
#include <avtSTLFileFormat.h>
#include <avtSTSDFileFormatInterface.h>
#include <avtGenericDatabase.h>

// ****************************************************************************
//  Method:  STLCommonPluginInfo::GetDatabaseType
//
//  Purpose:
//    Returns the type of a STL database.
//
//  Programmer:  meredith -- generated by xml2info
//  Creation:    Tue Feb 22 14:45:16 PST 2005
//
// ****************************************************************************
DatabaseType
STLCommonPluginInfo::GetDatabaseType()
{
    return DB_TYPE_STSD;
}

// ****************************************************************************
//  Method:  STLCommonPluginInfo::GetDefaultExtensions
//
//  Purpose:
//    Returns the default extensions for a STL database.
//
//  Programmer:  meredith -- generated by xml2info
//  Creation:    Tue Feb 22 14:45:16 PST 2005
//
// ****************************************************************************
std::vector<std::string>
STLCommonPluginInfo::GetDefaultExtensions()
{
    std::vector<std::string> defaultExtensions;
    defaultExtensions.push_back("stl");

    return defaultExtensions;
}

// ****************************************************************************
//  Method: STLCommonPluginInfo::SetUpSTLDatabase
//
//  Purpose:
//      Sets up a STL database.
//
//  Arguments:
//      list    A list of file names.
//      nList   The number of timesteps in list.
//      nBlocks The number of blocks in the list.
//
//  Returns:    A STL database from list.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Tue Feb 22 14:45:16 PST 2005
//
// ****************************************************************************
avtDatabase *
STLCommonPluginInfo::SetupDatabase(const char *const *list,
                                   int nList, int nBlock)
{
    avtSTSDFileFormat ***ffl = new avtSTSDFileFormat**[nList];
    int nTimestep = nList / nBlock;
    for (int i = 0 ; i < nTimestep ; i++)
    {
        ffl[i] = new avtSTSDFileFormat*[nBlock];
        for (int j = 0 ; j < nBlock ; j++)
        {
            ffl[i][j] = new avtSTLFileFormat(list[i*nBlock + j]);
        }
    }
    avtSTSDFileFormatInterface *inter 
           = new avtSTSDFileFormatInterface(ffl, nTimestep, nBlock);
    return new avtGenericDatabase(inter);
}
