// ****************************************************************************
//                               SARPluginInfo.h
// ****************************************************************************

#ifndef SAR_PLUGIN_INFO_H
#define SAR_PLUGIN_INFO_H
#include <DatabasePluginInfo.h>
#include <database_plugin_exports.h>

class avtDatabase;
class avtDatabaseWriter;

// ****************************************************************************
//  Class: SARDatabasePluginInfo
//
//  Purpose:
//    Classes that provide all the information about the SAR plugin.
//    Portions are separated into pieces relevant to the appropriate
//    components of VisIt.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Tue Feb 22 14:44:49 PST 2005
//
//  Modifications:
//
// ****************************************************************************

class SARGeneralPluginInfo : public virtual GeneralDatabasePluginInfo
{
  public:
    virtual char *GetName() const;
    virtual char *GetVersion() const;
    virtual char *GetID() const;
    virtual bool  EnabledByDefault() const;
    virtual bool  HasWriter() const;
};

class SARCommonPluginInfo : public virtual CommonDatabasePluginInfo, public virtual SARGeneralPluginInfo
{
  public:
    virtual DatabaseType              GetDatabaseType();
    virtual std::vector<std::string>  GetDefaultExtensions();
    virtual avtDatabase              *SetupDatabase(const char * const *list,
                                                    int nList, int nBlock);
};

class SARMDServerPluginInfo : public virtual MDServerDatabasePluginInfo, public virtual SARCommonPluginInfo
{
  public:
    // this makes compilers happy... remove if we ever have functions here
    virtual void dummy();
};

class SAREnginePluginInfo : public virtual EngineDatabasePluginInfo, public virtual SARCommonPluginInfo
{
  public:
    virtual avtDatabaseWriter        *GetWriter(void);
};

#endif
