#include <SARPluginInfo.h>
#include <avtSARFileFormat.h>
#include <avtSTSDFileFormatInterface.h>
#include <avtGenericDatabase.h>

// ****************************************************************************
//  Method:  SARCommonPluginInfo::GetDatabaseType
//
//  Purpose:
//    Returns the type of a SAR database.
//
//  Programmer:  meredith -- generated by xml2info
//  Creation:    Tue Feb 22 14:44:49 PST 2005
//
// ****************************************************************************
DatabaseType
SARCommonPluginInfo::GetDatabaseType()
{
    return DB_TYPE_STSD;
}

// ****************************************************************************
//  Method:  SARCommonPluginInfo::GetDefaultExtensions
//
//  Purpose:
//    Returns the default extensions for a SAR database.
//
//  Programmer:  meredith -- generated by xml2info
//  Creation:    Tue Feb 22 14:44:49 PST 2005
//
// ****************************************************************************
std::vector<std::string>
SARCommonPluginInfo::GetDefaultExtensions()
{
    std::vector<std::string> defaultExtensions;
    defaultExtensions.push_back("sar");
    defaultExtensions.push_back("SAR");

    return defaultExtensions;
}

// ****************************************************************************
//  Method: SARCommonPluginInfo::SetUpSARDatabase
//
//  Purpose:
//      Sets up a SAR database.
//
//  Arguments:
//      list    A list of file names.
//      nList   The number of timesteps in list.
//      nBlocks The number of blocks in the list.
//
//  Returns:    A SAR database from list.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Tue Feb 22 14:44:49 PST 2005
//
// ****************************************************************************
avtDatabase *
SARCommonPluginInfo::SetupDatabase(const char *const *list,
                                   int nList, int nBlock)
{
    avtSTSDFileFormat ***ffl = new avtSTSDFileFormat**[nList];
    int nTimestep = nList / nBlock;
    for (int i = 0 ; i < nTimestep ; i++)
    {
        ffl[i] = new avtSTSDFileFormat*[nBlock];
        for (int j = 0 ; j < nBlock ; j++)
        {
            ffl[i][j] = new avtSARFileFormat(list[i*nBlock + j]);
        }
    }
    avtSTSDFileFormatInterface *inter 
           = new avtSTSDFileFormatInterface(ffl, nTimestep, nBlock);
    return new avtGenericDatabase(inter);
}
