#include <SAMRAIPluginInfo.h>
#include <avtSAMRAIFileFormat.h>
#include <avtSTMDFileFormatInterface.h>
#include <avtGenericDatabase.h>

// ****************************************************************************
//  Method:  SAMRAICommonPluginInfo::GetDatabaseType
//
//  Purpose:
//    Returns the type of a SAMRAI database.
//
//  Programmer:  meredith -- generated by xml2info
//  Creation:    Tue Feb 22 14:43:57 PST 2005
//
// ****************************************************************************
DatabaseType
SAMRAICommonPluginInfo::GetDatabaseType()
{
    return DB_TYPE_STMD;
}

// ****************************************************************************
//  Method:  SAMRAICommonPluginInfo::GetDefaultExtensions
//
//  Purpose:
//    Returns the default extensions for a SAMRAI database.
//
//  Programmer:  meredith -- generated by xml2info
//  Creation:    Tue Feb 22 14:43:57 PST 2005
//
// ****************************************************************************
std::vector<std::string>
SAMRAICommonPluginInfo::GetDefaultExtensions()
{
    std::vector<std::string> defaultExtensions;
    defaultExtensions.push_back("samrai");

    return defaultExtensions;
}

// ****************************************************************************
//  Method: SAMRAICommonPluginInfo::SetUpSAMRAIDatabase
//
//  Purpose:
//      Sets up a SAMRAI database.
//
//  Arguments:
//      list    A list of file names.
//      nList   The number of timesteps in list.
//      nBlocks The number of blocks in the list.
//
//  Returns:    A SAMRAI database from list.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Tue Feb 22 14:43:57 PST 2005
//
// ****************************************************************************
avtDatabase *
SAMRAICommonPluginInfo::SetupDatabase(const char *const *list,
                                   int nList, int nBlock)
{
    avtSTMDFileFormat **ffl = new avtSTMDFileFormat*[nList];
    for (int i = 0 ; i < nList ; i++)
    {
        ffl[i] = new avtSAMRAIFileFormat(list[i]);
    }
    avtSTMDFileFormatInterface *inter 
           = new avtSTMDFileFormatInterface(ffl, nList);
    return new avtGenericDatabase(inter);
}
