// ****************************************************************************
//                               SAFPluginInfo.h
// ****************************************************************************

#ifndef SAF_PLUGIN_INFO_H
#define SAF_PLUGIN_INFO_H
#include <DatabasePluginInfo.h>
#include <database_plugin_exports.h>

class avtDatabase;
class avtDatabaseWriter;

// ****************************************************************************
//  Class: SAFDatabasePluginInfo
//
//  Purpose:
//    Classes that provide all the information about the SAF plugin.
//    Portions are separated into pieces relevant to the appropriate
//    components of VisIt.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Tue Feb 22 14:43:39 PST 2005
//
//  Modifications:
//
// ****************************************************************************

class SAFGeneralPluginInfo : public virtual GeneralDatabasePluginInfo
{
  public:
    virtual char *GetName() const;
    virtual char *GetVersion() const;
    virtual char *GetID() const;
    virtual bool  EnabledByDefault() const;
    virtual bool  HasWriter() const;
};

class SAFCommonPluginInfo : public virtual CommonDatabasePluginInfo, public virtual SAFGeneralPluginInfo
{
  public:
    virtual DatabaseType              GetDatabaseType();
    virtual std::vector<std::string>  GetDefaultExtensions();
    virtual avtDatabase              *SetupDatabase(const char * const *list,
                                                    int nList, int nBlock);
};

class SAFMDServerPluginInfo : public virtual MDServerDatabasePluginInfo, public virtual SAFCommonPluginInfo
{
  public:
    // this makes compilers happy... remove if we ever have functions here
    virtual void dummy();
};

class SAFEnginePluginInfo : public virtual EngineDatabasePluginInfo, public virtual SAFCommonPluginInfo
{
  public:
    virtual avtDatabaseWriter        *GetWriter(void);
};

#endif
