#include <SAFPluginInfo.h>
#include <avtSAFDatabase.h>

// ****************************************************************************
//  Method:  SAFCommonPluginInfo::GetDatabaseType
//
//  Purpose:
//    Returns the type of a SAF database.
//
//  Programmer:  meredith -- generated by xml2info
//  Creation:    Tue Feb 22 14:43:39 PST 2005
//
// ****************************************************************************
DatabaseType
SAFCommonPluginInfo::GetDatabaseType()
{
    return DB_TYPE_CUSTOM;
}

// ****************************************************************************
//  Method:  SAFCommonPluginInfo::GetDefaultExtensions
//
//  Purpose:
//    Returns the default extensions for a SAF database.
//
//  Programmer:  meredith -- generated by xml2info
//  Creation:    Tue Feb 22 14:43:39 PST 2005
//
// ****************************************************************************
std::vector<std::string>
SAFCommonPluginInfo::GetDefaultExtensions()
{
    std::vector<std::string> defaultExtensions;
    defaultExtensions.push_back("saf");

    return defaultExtensions;
}

// ****************************************************************************
//  Method: SAFCommonPluginInfo::SetUpSAFDatabase
//
//  Purpose:
//      Sets up a SAF database.
//
//  Arguments:
//      list    A list of file names.
//      nList   The number of timesteps in list.
//      nBlocks The number of blocks in the list.
//
//  Returns:    A SAF database from list.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Tue Feb 22 14:43:39 PST 2005
//
// ****************************************************************************
avtDatabase *
SAFCommonPluginInfo::SetupDatabase(const char *const *list,
                                   int nList, int nBlock)
{
    return new avtSAFDatabase(list[0]);
}
