// ****************************************************************************
//                               RectPluginInfo.h
// ****************************************************************************

#ifndef RECT_PLUGIN_INFO_H
#define RECT_PLUGIN_INFO_H
#include <DatabasePluginInfo.h>
#include <database_plugin_exports.h>

class avtDatabase;
class avtDatabaseWriter;

// ****************************************************************************
//  Class: RectDatabasePluginInfo
//
//  Purpose:
//    Classes that provide all the information about the Rect plugin.
//    Portions are separated into pieces relevant to the appropriate
//    components of VisIt.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Tue Feb 22 14:43:14 PST 2005
//
//  Modifications:
//
// ****************************************************************************

class RectGeneralPluginInfo : public virtual GeneralDatabasePluginInfo
{
  public:
    virtual char *GetName() const;
    virtual char *GetVersion() const;
    virtual char *GetID() const;
    virtual bool  EnabledByDefault() const;
    virtual bool  HasWriter() const;
};

class RectCommonPluginInfo : public virtual CommonDatabasePluginInfo, public virtual RectGeneralPluginInfo
{
  public:
    virtual DatabaseType              GetDatabaseType();
    virtual std::vector<std::string>  GetDefaultExtensions();
    virtual avtDatabase              *SetupDatabase(const char * const *list,
                                                    int nList, int nBlock);
};

class RectMDServerPluginInfo : public virtual MDServerDatabasePluginInfo, public virtual RectCommonPluginInfo
{
  public:
    // this makes compilers happy... remove if we ever have functions here
    virtual void dummy();
};

class RectEnginePluginInfo : public virtual EngineDatabasePluginInfo, public virtual RectCommonPluginInfo
{
  public:
    virtual avtDatabaseWriter        *GetWriter(void);
};

#endif
