#include <RectPluginInfo.h>
#include <avtRectFileFormat.h>
#include <avtMTMDFileFormatInterface.h>
#include <avtGenericDatabase.h>

// ****************************************************************************
//  Method:  RectCommonPluginInfo::GetDatabaseType
//
//  Purpose:
//    Returns the type of a Rect database.
//
//  Programmer:  meredith -- generated by xml2info
//  Creation:    Tue Feb 22 14:43:14 PST 2005
//
// ****************************************************************************
DatabaseType
RectCommonPluginInfo::GetDatabaseType()
{
    return DB_TYPE_MTMD;
}

// ****************************************************************************
//  Method:  RectCommonPluginInfo::GetDefaultExtensions
//
//  Purpose:
//    Returns the default extensions for a Rect database.
//
//  Programmer:  meredith -- generated by xml2info
//  Creation:    Tue Feb 22 14:43:14 PST 2005
//
// ****************************************************************************
std::vector<std::string>
RectCommonPluginInfo::GetDefaultExtensions()
{
    std::vector<std::string> defaultExtensions;
    defaultExtensions.push_back("viz");

    return defaultExtensions;
}

// ****************************************************************************
//  Method: RectCommonPluginInfo::SetUpRectDatabase
//
//  Purpose:
//      Sets up a Rect database.
//
//  Arguments:
//      list    A list of file names.
//      nList   The number of timesteps in list.
//      nBlocks The number of blocks in the list.
//
//  Returns:    A Rect database from list.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Tue Feb 22 14:43:14 PST 2005
//
// ****************************************************************************
avtDatabase *
RectCommonPluginInfo::SetupDatabase(const char *const *list,
                                   int nList, int nBlock)
{
    return new avtGenericDatabase(
               new avtMTMDFileFormatInterface(
                   new avtRectFileFormat(list[0])));
}
