#include <Point3DPluginInfo.h>
#include <avtPoint3DFileFormat.h>
#include <avtSTSDFileFormatInterface.h>
#include <avtGenericDatabase.h>

// ****************************************************************************
//  Method:  Point3DCommonPluginInfo::GetDatabaseType
//
//  Purpose:
//    Returns the type of a Point3D database.
//
//  Programmer:  meredith -- generated by xml2info
//  Creation:    Tue Feb 22 14:42:56 PST 2005
//
// ****************************************************************************
DatabaseType
Point3DCommonPluginInfo::GetDatabaseType()
{
    return DB_TYPE_STSD;
}

// ****************************************************************************
//  Method:  Point3DCommonPluginInfo::GetDefaultExtensions
//
//  Purpose:
//    Returns the default extensions for a Point3D database.
//
//  Programmer:  meredith -- generated by xml2info
//  Creation:    Tue Feb 22 14:42:56 PST 2005
//
// ****************************************************************************
std::vector<std::string>
Point3DCommonPluginInfo::GetDefaultExtensions()
{
    std::vector<std::string> defaultExtensions;
    defaultExtensions.push_back(".3D");

    return defaultExtensions;
}

// ****************************************************************************
//  Method: Point3DCommonPluginInfo::SetUpPoint3DDatabase
//
//  Purpose:
//      Sets up a Point3D database.
//
//  Arguments:
//      list    A list of file names.
//      nList   The number of timesteps in list.
//      nBlocks The number of blocks in the list.
//
//  Returns:    A Point3D database from list.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Tue Feb 22 14:42:56 PST 2005
//
// ****************************************************************************
avtDatabase *
Point3DCommonPluginInfo::SetupDatabase(const char *const *list,
                                   int nList, int nBlock)
{
    avtSTSDFileFormat ***ffl = new avtSTSDFileFormat**[nList];
    int nTimestep = nList / nBlock;
    for (int i = 0 ; i < nTimestep ; i++)
    {
        ffl[i] = new avtSTSDFileFormat*[nBlock];
        for (int j = 0 ; j < nBlock ; j++)
        {
            ffl[i][j] = new avtPoint3DFileFormat(list[i*nBlock + j]);
        }
    }
    avtSTSDFileFormatInterface *inter 
           = new avtSTSDFileFormatInterface(ffl, nTimestep, nBlock);
    return new avtGenericDatabase(inter);
}
