// ************************************************************************* //
//  File: PixiePluginInfo.C
// ************************************************************************* //

#include <PixiePluginInfo.h>

#if defined(__APPLE__)
#define GetGeneralInfo Pixie_GetGeneralInfo
#endif

// ****************************************************************************
//  Function:  GetGeneralInfo
//
//  Purpose:
//    Return a new GeneralPluginInfo for the Pixie database.
//
//  Programmer:  meredith -- generated by xml2info
//  Creation:    Tue Feb 22 14:42:22 PST 2005
//
// ****************************************************************************
extern "C" GeneralDatabasePluginInfo* GetGeneralInfo()
{
    return new PixieGeneralPluginInfo;
}

// ****************************************************************************
//  Method: PixieGeneralPluginInfo::GetName
//
//  Purpose:
//    Return the name of the database plugin.
//
//  Returns:    A pointer to the name of the database plugin.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Tue Feb 22 14:42:22 PST 2005
//
// ****************************************************************************

char *
PixieGeneralPluginInfo::GetName() const
{
    return "Pixie";
}

// ****************************************************************************
//  Method: PixieGeneralPluginInfo::GetVersion
//
//  Purpose:
//    Return the version of the database plugin.
//
//  Returns:    A pointer to the version of the database plugin.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Tue Feb 22 14:42:22 PST 2005
//
// ****************************************************************************

char *
PixieGeneralPluginInfo::GetVersion() const
{
    return "1.0";
}

// ****************************************************************************
//  Method: PixieGeneralPluginInfo::GetID
//
//  Purpose:
//    Return the id of the database plugin.
//
//  Returns:    A pointer to the id of the database plugin.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Tue Feb 22 14:42:22 PST 2005
//
// ****************************************************************************

char *
PixieGeneralPluginInfo::GetID() const
{
    return "Pixie_1.0";
}
// ****************************************************************************
//  Method: PixieGeneralPluginInfo::EnabledByDefault
//
//  Purpose:
//    Return true if this plugin should be enabled by default; false otherwise.
//
//  Returns:    true/false
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Tue Feb 22 14:42:22 PST 2005
//
// ****************************************************************************

bool
PixieGeneralPluginInfo::EnabledByDefault() const
{
    return true;
}
// ****************************************************************************
//  Method: PixieGeneralPluginInfo::HasWriter
//
//  Purpose:
//    Return true if this plugin has a database writer.
//
//  Returns:    true/false
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Tue Feb 22 14:42:22 PST 2005
//
// ****************************************************************************

bool
PixieGeneralPluginInfo::HasWriter() const
{
    return false;
}
