#include <PixiePluginInfo.h>
#include <avtPixieFileFormat.h>
#include <avtMTSDFileFormatInterface.h>
#include <avtGenericDatabase.h>

// ****************************************************************************
//  Method:  PixieCommonPluginInfo::GetDatabaseType
//
//  Purpose:
//    Returns the type of a Pixie database.
//
//  Programmer:  meredith -- generated by xml2info
//  Creation:    Tue Feb 22 14:42:22 PST 2005
//
// ****************************************************************************
DatabaseType
PixieCommonPluginInfo::GetDatabaseType()
{
    return DB_TYPE_MTSD;
}

// ****************************************************************************
//  Method:  PixieCommonPluginInfo::GetDefaultExtensions
//
//  Purpose:
//    Returns the default extensions for a Pixie database.
//
//  Programmer:  meredith -- generated by xml2info
//  Creation:    Tue Feb 22 14:42:22 PST 2005
//
// ****************************************************************************
std::vector<std::string>
PixieCommonPluginInfo::GetDefaultExtensions()
{
    std::vector<std::string> defaultExtensions;
    defaultExtensions.push_back("h5");

    return defaultExtensions;
}

// ****************************************************************************
//  Method: PixieCommonPluginInfo::SetUpPixieDatabase
//
//  Purpose:
//      Sets up a Pixie database.
//
//  Arguments:
//      list    A list of file names.
//      nList   The number of timesteps in list.
//      nBlocks The number of blocks in the list.
//
//  Returns:    A Pixie database from list.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Aug 13 14:31:41 PST 2004
//
//  Modifications:
//    Brad Whitlock, Fri Aug 13 18:47:12 PST 2004
//    Added some exception handline so the file formats are deleted if
//    if creating one of them causes an exception to be generated.
//
// ****************************************************************************

avtDatabase *
PixieCommonPluginInfo::SetupDatabase(const char *const *list,
                                   int nList, int nBlock)
{
    avtMTSDFileFormat **ffl = new avtMTSDFileFormat*[nList];
    for (int i = 0 ; i < nList ; i++)
        ffl[i] = 0;

    TRY
    {
        for (int i = 0 ; i < nList ; i++)
            ffl[i] = new avtPixieFileFormat(list[i]);
    }
    CATCH(VisItException)
    {
        for (int i = 0 ; i < nList ; i++)
        {
            if(ffl[i] != 0)
                delete ffl[i];
        }
        delete [] ffl;
        RETHROW;
    }
    ENDTRY

    avtMTSDFileFormatInterface *inter 
        = new avtMTSDFileFormatInterface(ffl, nList);

    return new avtGenericDatabase(inter);
}
