#include <PLOT3DPluginInfo.h>
#include <avtPLOT3DFileFormat.h>
#include <avtSTMDFileFormatInterface.h>
#include <avtGenericDatabase.h>

// ****************************************************************************
//  Method:  PLOT3DCommonPluginInfo::GetDatabaseType
//
//  Purpose:
//    Returns the type of a PLOT3D database.
//
//  Programmer:  meredith -- generated by xml2info
//  Creation:    Tue Feb 22 14:41:56 PST 2005
//
// ****************************************************************************
DatabaseType
PLOT3DCommonPluginInfo::GetDatabaseType()
{
    return DB_TYPE_STMD;
}

// ****************************************************************************
//  Method:  PLOT3DCommonPluginInfo::GetDefaultExtensions
//
//  Purpose:
//    Returns the default extensions for a PLOT3D database.
//
//  Programmer:  meredith -- generated by xml2info
//  Creation:    Tue Feb 22 14:41:56 PST 2005
//
// ****************************************************************************
std::vector<std::string>
PLOT3DCommonPluginInfo::GetDefaultExtensions()
{
    std::vector<std::string> defaultExtensions;
    defaultExtensions.push_back("q");
    defaultExtensions.push_back("x");
    defaultExtensions.push_back("vp3d");

    return defaultExtensions;
}

// ****************************************************************************
//  Method: PLOT3DCommonPluginInfo::SetUpPLOT3DDatabase
//
//  Purpose:
//      Sets up a PLOT3D database.
//
//  Arguments:
//      list    A list of file names.
//      nList   The number of timesteps in list.
//      nBlocks The number of blocks in the list.
//
//  Returns:    A PLOT3D database from list.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Tue Feb 22 14:41:56 PST 2005
//
// ****************************************************************************
avtDatabase *
PLOT3DCommonPluginInfo::SetupDatabase(const char *const *list,
                                   int nList, int nBlock)
{
    avtSTMDFileFormat **ffl = new avtSTMDFileFormat*[nList];
    for (int i = 0 ; i < nList ; i++)
    {
        ffl[i] = new avtPLOT3DFileFormat(list[i]);
    }
    avtSTMDFileFormatInterface *inter 
           = new avtSTMDFileFormatInterface(ffl, nList);
    return new avtGenericDatabase(inter);
}
