#include <PLOT2DPluginInfo.h>
#include <avtPLOT2DFileFormat.h>
#include <avtSTSDFileFormatInterface.h>
#include <avtGenericDatabase.h>

// ****************************************************************************
//  Method:  PLOT2DCommonPluginInfo::GetDatabaseType
//
//  Purpose:
//    Returns the type of a PLOT2D database.
//
//  Programmer:  meredith -- generated by xml2info
//  Creation:    Tue Feb 22 14:41:37 PST 2005
//
// ****************************************************************************
DatabaseType
PLOT2DCommonPluginInfo::GetDatabaseType()
{
    return DB_TYPE_STSD;
}

// ****************************************************************************
//  Method:  PLOT2DCommonPluginInfo::GetDefaultExtensions
//
//  Purpose:
//    Returns the default extensions for a PLOT2D database.
//
//  Programmer:  meredith -- generated by xml2info
//  Creation:    Tue Feb 22 14:41:37 PST 2005
//
// ****************************************************************************
std::vector<std::string>
PLOT2DCommonPluginInfo::GetDefaultExtensions()
{
    std::vector<std::string> defaultExtensions;
    defaultExtensions.push_back("p2d");

    return defaultExtensions;
}

// ****************************************************************************
//  Method: PLOT2DCommonPluginInfo::SetUpPLOT2DDatabase
//
//  Purpose:
//      Sets up a PLOT2D database.
//
//  Arguments:
//      list    A list of file names.
//      nList   The number of timesteps in list.
//      nBlocks The number of blocks in the list.
//
//  Returns:    A PLOT2D database from list.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Tue Feb 22 14:41:37 PST 2005
//
// ****************************************************************************
avtDatabase *
PLOT2DCommonPluginInfo::SetupDatabase(const char *const *list,
                                   int nList, int nBlock)
{
    avtSTSDFileFormat ***ffl = new avtSTSDFileFormat**[nList];
    int nTimestep = nList / nBlock;
    for (int i = 0 ; i < nTimestep ; i++)
    {
        ffl[i] = new avtSTSDFileFormat*[nBlock];
        for (int j = 0 ; j < nBlock ; j++)
        {
            ffl[i][j] = new avtPLOT2DFileFormat(list[i*nBlock + j]);
        }
    }
    avtSTSDFileFormatInterface *inter 
           = new avtSTSDFileFormatInterface(ffl, nTimestep, nBlock);
    return new avtGenericDatabase(inter);
}
