#include <PDBPluginInfo.h>
#include <avtFileFormatInterface.h>
#include <avtGenericDatabase.h>
#include <avtPDBFileFormat.h>
#include <VisItException.h>

// ****************************************************************************
//  Method:  PDBCommonPluginInfo::GetDatabaseType
//
//  Purpose:
//    Returns the type of a PDB database.
//
//  Programmer:  whitlocb -- generated by xml2info
//  Creation:    Tue Apr 29 14:06:11 PST 2003
//
// ****************************************************************************
DatabaseType
PDBCommonPluginInfo::GetDatabaseType()
{
    return DB_TYPE_MTSD;
}

// ****************************************************************************
//  Method:  PDBCommonPluginInfo::GetDefaultExtensions
//
//  Purpose:
//    Returns the default extensions for a PDB database.
//
//  Programmer:  whitlocb -- generated by xml2info
//  Creation:    Tue Apr 29 14:06:11 PST 2003
//
// ****************************************************************************
std::vector<std::string>
PDBCommonPluginInfo::GetDefaultExtensions()
{
    std::vector<std::string> defaultExtensions;
    defaultExtensions.push_back("pdb");
    defaultExtensions.push_back("r0000");

    return defaultExtensions;
}

// ****************************************************************************
//  Method: PDBCommonPluginInfo::SetUpPDBDatabase
//
//  Purpose:
//      Sets up a PDB database.
//
//  Arguments:
//      list    A list of file names.
//      nList   The number of timesteps in list.
//      nBlocks The number of blocks in the list.
//
//  Returns:    A PDB database from list.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Tue Apr 29 14:06:11 PST 2003
//
//  Modifications:
//    Brad Whitlock, Mon Jun 30 16:16:19 PST 2003
//    I had to add some custom code so the first file in the list gets opened
//    immediately. I also recoded how initialization occurs because
//    avtPDBFileFormat's constructor can throw an exception if we're not
//    opening a supported flavor of PDB.
//
//    Brad Whitlock, Tue Sep 16 11:42:56 PDT 2003
//    I rewrote this method so the plugin can have internal file formats
//    that have varying file format interfaces.
//
// ****************************************************************************

avtDatabase *
PDBCommonPluginInfo::SetupDatabase(const char *const *list,
                                   int nList, int nBlock)
{
    avtDatabase *db = 0;

    //
    // Create a file format interface based on information in the files.
    //
    avtFileFormatInterface *inter = CreateFileFormatInterface(list, nList, nBlock);

    // If we created a file format interface, try creating a database.
    if(inter)
    {
        // Try and create the database using the interface that was created.
        TRY
        {
            db = new avtGenericDatabase(inter);
        }
        CATCH(VisItException)
        {
            delete inter;
            delete db;
            RETHROW;
        }
        ENDTRY
    }

    return db;
}
