// ****************************************************************************
//                               OVERFLOWPluginInfo.h
// ****************************************************************************

#ifndef OVERFLOW_PLUGIN_INFO_H
#define OVERFLOW_PLUGIN_INFO_H
#include <DatabasePluginInfo.h>
#include <database_plugin_exports.h>

class avtDatabase;
class avtDatabaseWriter;

// ****************************************************************************
//  Class: OVERFLOWDatabasePluginInfo
//
//  Purpose:
//    Classes that provide all the information about the OVERFLOW plugin.
//    Portions are separated into pieces relevant to the appropriate
//    components of VisIt.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Tue Feb 22 14:40:49 PST 2005
//
//  Modifications:
//
// ****************************************************************************

class OVERFLOWGeneralPluginInfo : public virtual GeneralDatabasePluginInfo
{
  public:
    virtual char *GetName() const;
    virtual char *GetVersion() const;
    virtual char *GetID() const;
    virtual bool  EnabledByDefault() const;
    virtual bool  HasWriter() const;
};

class OVERFLOWCommonPluginInfo : public virtual CommonDatabasePluginInfo, public virtual OVERFLOWGeneralPluginInfo
{
  public:
    virtual DatabaseType              GetDatabaseType();
    virtual std::vector<std::string>  GetDefaultExtensions();
    virtual avtDatabase              *SetupDatabase(const char * const *list,
                                                    int nList, int nBlock);
};

class OVERFLOWMDServerPluginInfo : public virtual MDServerDatabasePluginInfo, public virtual OVERFLOWCommonPluginInfo
{
  public:
    // this makes compilers happy... remove if we ever have functions here
    virtual void dummy();
};

class OVERFLOWEnginePluginInfo : public virtual EngineDatabasePluginInfo, public virtual OVERFLOWCommonPluginInfo
{
  public:
    virtual avtDatabaseWriter        *GetWriter(void);
};

#endif
