#include <OVERFLOWPluginInfo.h>
#include <avtOVERFLOWFileFormat.h>
#include <avtSTMDFileFormatInterface.h>
#include <avtGenericDatabase.h>

// ****************************************************************************
//  Method:  OVERFLOWCommonPluginInfo::GetDatabaseType
//
//  Purpose:
//    Returns the type of a OVERFLOW database.
//
//  Programmer:  meredith -- generated by xml2info
//  Creation:    Tue Feb 22 14:40:49 PST 2005
//
// ****************************************************************************
DatabaseType
OVERFLOWCommonPluginInfo::GetDatabaseType()
{
    return DB_TYPE_STMD;
}

// ****************************************************************************
//  Method:  OVERFLOWCommonPluginInfo::GetDefaultExtensions
//
//  Purpose:
//    Returns the default extensions for a OVERFLOW database.
//
//  Programmer:  meredith -- generated by xml2info
//  Creation:    Tue Feb 22 14:40:49 PST 2005
//
// ****************************************************************************
std::vector<std::string>
OVERFLOWCommonPluginInfo::GetDefaultExtensions()
{
    std::vector<std::string> defaultExtensions;
    defaultExtensions.push_back("dat");
    defaultExtensions.push_back("save");

    return defaultExtensions;
}

// ****************************************************************************
//  Method: OVERFLOWCommonPluginInfo::SetUpOVERFLOWDatabase
//
//  Purpose:
//      Sets up a OVERFLOW database.
//
//  Arguments:
//      list    A list of file names.
//      nList   The number of timesteps in list.
//      nBlocks The number of blocks in the list.
//
//  Returns:    A OVERFLOW database from list.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Tue Feb 22 14:40:49 PST 2005
//
// ****************************************************************************
avtDatabase *
OVERFLOWCommonPluginInfo::SetupDatabase(const char *const *list,
                                   int nList, int nBlock)
{
    avtSTMDFileFormat **ffl = new avtSTMDFileFormat*[nList];
    for (int i = 0 ; i < nList ; i++)
    {
        ffl[i] = new avtOVERFLOWFileFormat(list[i]);
    }
    avtSTMDFileFormatInterface *inter 
           = new avtSTMDFileFormatInterface(ffl, nList);
    return new avtGenericDatabase(inter);
}
