// ****************************************************************************
//                               MiliPluginInfo.h
// ****************************************************************************

#ifndef MILI_PLUGIN_INFO_H
#define MILI_PLUGIN_INFO_H
#include <DatabasePluginInfo.h>
#include <database_plugin_exports.h>

class avtDatabase;
class avtDatabaseWriter;

// ****************************************************************************
//  Class: MiliDatabasePluginInfo
//
//  Purpose:
//    Classes that provide all the information about the Mili plugin.
//    Portions are separated into pieces relevant to the appropriate
//    components of VisIt.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Tue Feb 22 14:40:24 PST 2005
//
//  Modifications:
//
// ****************************************************************************

class MiliGeneralPluginInfo : public virtual GeneralDatabasePluginInfo
{
  public:
    virtual char *GetName() const;
    virtual char *GetVersion() const;
    virtual char *GetID() const;
    virtual bool  EnabledByDefault() const;
    virtual bool  HasWriter() const;
};

class MiliCommonPluginInfo : public virtual CommonDatabasePluginInfo, public virtual MiliGeneralPluginInfo
{
  public:
    virtual DatabaseType              GetDatabaseType();
    virtual std::vector<std::string>  GetDefaultExtensions();
    virtual avtDatabase              *SetupDatabase(const char * const *list,
                                                    int nList, int nBlock);
};

class MiliMDServerPluginInfo : public virtual MDServerDatabasePluginInfo, public virtual MiliCommonPluginInfo
{
  public:
    // this makes compilers happy... remove if we ever have functions here
    virtual void dummy();
};

class MiliEnginePluginInfo : public virtual EngineDatabasePluginInfo, public virtual MiliCommonPluginInfo
{
  public:
    virtual avtDatabaseWriter        *GetWriter(void);
};

#endif
