#include <MiliPluginInfo.h>
#include <avtMiliFileFormat.h>
#include <avtMTMDFileFormatInterface.h>
#include <avtGenericDatabase.h>

// ****************************************************************************
//  Method:  MiliCommonPluginInfo::GetDatabaseType
//
//  Purpose:
//    Returns the type of a Mili database.
//
//  Programmer:  meredith -- generated by xml2info
//  Creation:    Tue Feb 22 14:40:24 PST 2005
//
// ****************************************************************************
DatabaseType
MiliCommonPluginInfo::GetDatabaseType()
{
    return DB_TYPE_MTMD;
}

// ****************************************************************************
//  Method:  MiliCommonPluginInfo::GetDefaultExtensions
//
//  Purpose:
//    Returns the default extensions for a Mili database.
//
//  Programmer:  meredith -- generated by xml2info
//  Creation:    Tue Feb 22 14:40:24 PST 2005
//
// ****************************************************************************
std::vector<std::string>
MiliCommonPluginInfo::GetDefaultExtensions()
{
    std::vector<std::string> defaultExtensions;
    defaultExtensions.push_back(".mili");
    defaultExtensions.push_back(".m");

    return defaultExtensions;
}

// ****************************************************************************
//  Method: MiliCommonPluginInfo::SetUpMiliDatabase
//
//  Purpose:
//      Sets up a Mili database.
//
//  Arguments:
//      list    A list of file names.
//      nList   The number of timesteps in list.
//      nBlocks The number of blocks in the list.
//
//  Returns:    A Mili database from list.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Tue Feb 22 14:40:24 PST 2005
//
// ****************************************************************************
avtDatabase *
MiliCommonPluginInfo::SetupDatabase(const char *const *list,
                                   int nList, int nBlock)
{
    return new avtGenericDatabase(
               new avtMTMDFileFormatInterface(
                   new avtMiliFileFormat(list[0])));
}
