// ****************************************************************************
//                               LinesPluginInfo.h
// ****************************************************************************

#ifndef LINES_PLUGIN_INFO_H
#define LINES_PLUGIN_INFO_H
#include <DatabasePluginInfo.h>
#include <database_plugin_exports.h>

class avtDatabase;
class avtDatabaseWriter;

// ****************************************************************************
//  Class: LinesDatabasePluginInfo
//
//  Purpose:
//    Classes that provide all the information about the Lines plugin.
//    Portions are separated into pieces relevant to the appropriate
//    components of VisIt.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Tue Feb 22 14:40:07 PST 2005
//
//  Modifications:
//
// ****************************************************************************

class LinesGeneralPluginInfo : public virtual GeneralDatabasePluginInfo
{
  public:
    virtual char *GetName() const;
    virtual char *GetVersion() const;
    virtual char *GetID() const;
    virtual bool  EnabledByDefault() const;
    virtual bool  HasWriter() const;
};

class LinesCommonPluginInfo : public virtual CommonDatabasePluginInfo, public virtual LinesGeneralPluginInfo
{
  public:
    virtual DatabaseType              GetDatabaseType();
    virtual std::vector<std::string>  GetDefaultExtensions();
    virtual avtDatabase              *SetupDatabase(const char * const *list,
                                                    int nList, int nBlock);
};

class LinesMDServerPluginInfo : public virtual MDServerDatabasePluginInfo, public virtual LinesCommonPluginInfo
{
  public:
    // this makes compilers happy... remove if we ever have functions here
    virtual void dummy();
};

class LinesEnginePluginInfo : public virtual EngineDatabasePluginInfo, public virtual LinesCommonPluginInfo
{
  public:
    virtual avtDatabaseWriter        *GetWriter(void);
};

#endif
