#include <LinesPluginInfo.h>
#include <avtLinesFileFormat.h>
#include <avtSTMDFileFormatInterface.h>
#include <avtGenericDatabase.h>

// ****************************************************************************
//  Method:  LinesCommonPluginInfo::GetDatabaseType
//
//  Purpose:
//    Returns the type of a Lines database.
//
//  Programmer:  meredith -- generated by xml2info
//  Creation:    Tue Feb 22 14:40:07 PST 2005
//
// ****************************************************************************
DatabaseType
LinesCommonPluginInfo::GetDatabaseType()
{
    return DB_TYPE_STMD;
}

// ****************************************************************************
//  Method:  LinesCommonPluginInfo::GetDefaultExtensions
//
//  Purpose:
//    Returns the default extensions for a Lines database.
//
//  Programmer:  meredith -- generated by xml2info
//  Creation:    Tue Feb 22 14:40:07 PST 2005
//
// ****************************************************************************
std::vector<std::string>
LinesCommonPluginInfo::GetDefaultExtensions()
{
    std::vector<std::string> defaultExtensions;

    return defaultExtensions;
}

// ****************************************************************************
//  Method: LinesCommonPluginInfo::SetUpLinesDatabase
//
//  Purpose:
//      Sets up a Lines database.
//
//  Arguments:
//      list    A list of file names.
//      nList   The number of timesteps in list.
//      nBlocks The number of blocks in the list.
//
//  Returns:    A Lines database from list.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Tue Feb 22 14:40:07 PST 2005
//
// ****************************************************************************
avtDatabase *
LinesCommonPluginInfo::SetupDatabase(const char *const *list,
                                   int nList, int nBlock)
{
    avtSTMDFileFormat **ffl = new avtSTMDFileFormat*[nList];
    for (int i = 0 ; i < nList ; i++)
    {
        ffl[i] = new avtLinesFileFormat(list[i]);
    }
    avtSTMDFileFormatInterface *inter 
           = new avtSTMDFileFormatInterface(ffl, nList);
    return new avtGenericDatabase(inter);
}
