#include <ImagePluginInfo.h>
#include <avtImageFileFormat.h>
#include <avtSTSDFileFormatInterface.h>
#include <avtGenericDatabase.h>

// ****************************************************************************
//  Method:  ImageCommonPluginInfo::GetDatabaseType
//
//  Purpose:
//    Returns the type of a Image database.
//
//  Programmer:  meredith -- generated by xml2info
//  Creation:    Tue Feb 22 14:39:26 PST 2005
//
// ****************************************************************************
DatabaseType
ImageCommonPluginInfo::GetDatabaseType()
{
    return DB_TYPE_STSD;
}

// ****************************************************************************
//  Method:  ImageCommonPluginInfo::GetDefaultExtensions
//
//  Purpose:
//    Returns the default extensions for a Image database.
//
//  Programmer:  meredith -- generated by xml2info
//  Creation:    Tue Feb 22 14:39:26 PST 2005
//
// ****************************************************************************
std::vector<std::string>
ImageCommonPluginInfo::GetDefaultExtensions()
{
    std::vector<std::string> defaultExtensions;
    defaultExtensions.push_back("pnm");
    defaultExtensions.push_back("ppm");
    defaultExtensions.push_back("png");
    defaultExtensions.push_back("tiff");
    defaultExtensions.push_back("jpeg");
    defaultExtensions.push_back("jpg");
    defaultExtensions.push_back("tif");
    defaultExtensions.push_back("PNM");
    defaultExtensions.push_back("PPM");
    defaultExtensions.push_back("PNG");
    defaultExtensions.push_back("TIFF");
    defaultExtensions.push_back("JPEG");
    defaultExtensions.push_back("JPG");
    defaultExtensions.push_back("TIF");
    defaultExtensions.push_back("bmp");
    defaultExtensions.push_back("BMP");

    return defaultExtensions;
}

// ****************************************************************************
//  Method: ImageCommonPluginInfo::SetUpImageDatabase
//
//  Purpose:
//      Sets up a Image database.
//
//  Arguments:
//      list    A list of file names.
//      nList   The number of timesteps in list.
//      nBlocks The number of blocks in the list.
//
//  Returns:    A Image database from list.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Tue Feb 22 14:39:26 PST 2005
//
// ****************************************************************************
avtDatabase *
ImageCommonPluginInfo::SetupDatabase(const char *const *list,
                                   int nList, int nBlock)
{
    avtSTSDFileFormat ***ffl = new avtSTSDFileFormat**[nList];
    int nTimestep = nList / nBlock;
    for (int i = 0 ; i < nTimestep ; i++)
    {
        ffl[i] = new avtSTSDFileFormat*[nBlock];
        for (int j = 0 ; j < nBlock ; j++)
        {
            ffl[i][j] = new avtImageFileFormat(list[i*nBlock + j]);
        }
    }
    avtSTSDFileFormatInterface *inter 
           = new avtSTSDFileFormatInterface(ffl, nTimestep, nBlock);
    return new avtGenericDatabase(inter);
}
