#include <HexPluginInfo.h>
#include <avtHexFileFormat.h>
#include <avtSTMDFileFormatInterface.h>
#include <avtGenericDatabase.h>

// ****************************************************************************
//  Method:  HexCommonPluginInfo::GetDatabaseType
//
//  Purpose:
//    Returns the type of a Hex database.
//
//  Programmer:  meredith -- generated by xml2info
//  Creation:    Tue Feb 22 14:38:59 PST 2005
//
// ****************************************************************************
DatabaseType
HexCommonPluginInfo::GetDatabaseType()
{
    return DB_TYPE_STMD;
}

// ****************************************************************************
//  Method:  HexCommonPluginInfo::GetDefaultExtensions
//
//  Purpose:
//    Returns the default extensions for a Hex database.
//
//  Programmer:  meredith -- generated by xml2info
//  Creation:    Tue Feb 22 14:38:59 PST 2005
//
// ****************************************************************************
std::vector<std::string>
HexCommonPluginInfo::GetDefaultExtensions()
{
    std::vector<std::string> defaultExtensions;
    defaultExtensions.push_back("hex");

    return defaultExtensions;
}

// ****************************************************************************
//  Method: HexCommonPluginInfo::SetUpHexDatabase
//
//  Purpose:
//      Sets up a Hex database.
//
//  Arguments:
//      list    A list of file names.
//      nList   The number of timesteps in list.
//      nBlocks The number of blocks in the list.
//
//  Returns:    A Hex database from list.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Tue Feb 22 14:38:59 PST 2005
//
// ****************************************************************************
avtDatabase *
HexCommonPluginInfo::SetupDatabase(const char *const *list,
                                   int nList, int nBlock)
{
    avtSTMDFileFormat **ffl = new avtSTMDFileFormat*[nList];
    for (int i = 0 ; i < nList ; i++)
    {
        ffl[i] = new avtHexFileFormat(list[i]);
    }
    avtSTMDFileFormatInterface *inter 
           = new avtSTMDFileFormatInterface(ffl, nList);
    return new avtGenericDatabase(inter);
}
