// ****************************************************************************
//                               ExodusPluginInfo.h
// ****************************************************************************

#ifndef EXODUS_PLUGIN_INFO_H
#define EXODUS_PLUGIN_INFO_H
#include <DatabasePluginInfo.h>
#include <database_plugin_exports.h>

class avtDatabase;
class avtDatabaseWriter;

// ****************************************************************************
//  Class: ExodusDatabasePluginInfo
//
//  Purpose:
//    Classes that provide all the information about the Exodus plugin.
//    Portions are separated into pieces relevant to the appropriate
//    components of VisIt.
//
//  Programmer: meredith -- generated by xml2info
//  Creation:   Tue Feb 22 14:38:36 PST 2005
//
//  Modifications:
//
// ****************************************************************************

class ExodusGeneralPluginInfo : public virtual GeneralDatabasePluginInfo
{
  public:
    virtual char *GetName() const;
    virtual char *GetVersion() const;
    virtual char *GetID() const;
    virtual bool  EnabledByDefault() const;
    virtual bool  HasWriter() const;
};

class ExodusCommonPluginInfo : public virtual CommonDatabasePluginInfo, public virtual ExodusGeneralPluginInfo
{
  public:
    virtual DatabaseType              GetDatabaseType();
    virtual std::vector<std::string>  GetDefaultExtensions();
    virtual avtDatabase              *SetupDatabase(const char * const *list,
                                                    int nList, int nBlock);
};

class ExodusMDServerPluginInfo : public virtual MDServerDatabasePluginInfo, public virtual ExodusCommonPluginInfo
{
  public:
    // this makes compilers happy... remove if we ever have functions here
    virtual void dummy();
};

class ExodusEnginePluginInfo : public virtual EngineDatabasePluginInfo, public virtual ExodusCommonPluginInfo
{
  public:
    virtual avtDatabaseWriter        *GetWriter(void);
};

#endif
