#include <ExodusPluginInfo.h>
#include <avtExodusFileFormat.h>
#include <avtMTSDFileFormatInterface.h>
#include <avtGenericDatabase.h>

// ****************************************************************************
//  Method:  ExodusCommonPluginInfo::GetDatabaseType
//
//  Purpose:
//    Returns the type of a Exodus database.
//
//  Programmer:  meredith -- generated by xml2info
//  Creation:    Tue Feb 22 14:38:36 PST 2005
//
// ****************************************************************************
DatabaseType
ExodusCommonPluginInfo::GetDatabaseType()
{
    return DB_TYPE_MTSD;
}

// ****************************************************************************
//  Method:  ExodusCommonPluginInfo::GetDefaultExtensions
//
//  Purpose:
//    Returns the default extensions for a Exodus database.
//
//  Programmer:  meredith -- generated by xml2info
//  Creation:    Tue Feb 22 14:38:36 PST 2005
//
// ****************************************************************************
std::vector<std::string>
ExodusCommonPluginInfo::GetDefaultExtensions()
{
    std::vector<std::string> defaultExtensions;
    defaultExtensions.push_back("ex");
    defaultExtensions.push_back("e");
    defaultExtensions.push_back("exo");
    defaultExtensions.push_back("ex2");
    defaultExtensions.push_back("exII");
    defaultExtensions.push_back("exii");
    defaultExtensions.push_back("gen");
    defaultExtensions.push_back("EX");
    defaultExtensions.push_back("E");
    defaultExtensions.push_back("EXO");
    defaultExtensions.push_back("EX2");
    defaultExtensions.push_back("EXII");
    defaultExtensions.push_back("GEN");
    defaultExtensions.push_back("exodus");
    defaultExtensions.push_back("EXODUS");
    defaultExtensions.push_back("nemesis");
    defaultExtensions.push_back("NEMESIS");

    return defaultExtensions;
}

// ****************************************************************************
//  Method: ExodusCommonPluginInfo::SetUpExodusDatabase
//
//  Purpose:
//      Sets up a Exodus database.
//
//  Arguments:
//      list    A list of file names.
//      nList   The number of timesteps in list.
//      nBlocks The number of blocks in the list.
//
//  Returns:    A Exodus database from list.
//
//  Programmer: Jeremy Meredith
//  Creation:   August 27, 2002
//
//  Modifications:
//
//    Hank Childs, Tue Feb 25 13:56:42 PST 2003
//    Account for .EXODUS, .nemesis, and .NEMESIS.
//
//    Hank Childs, Thu Jul 22 11:29:31 PDT 2004
//    Register the file list 
// ****************************************************************************
avtDatabase *
ExodusCommonPluginInfo::SetupDatabase(const char *const *list,
                                   int nList, int nBlock)
{
    string file1 = list[0];

    bool containsManyFiles = false;
    if (nList == 1 &&
        file1.length() > 7 && file1.substr(file1.length()-7,7)==".exodus")
        containsManyFiles = true;
    if (nList == 1 &&
        file1.length() > 7 && file1.substr(file1.length()-7,7)==".EXODUS")
        containsManyFiles = true;
    if (nList == 1 &&
        file1.length() > 8 && file1.substr(file1.length()-8,8)==".nemesis")
        containsManyFiles = true;
    if (nList == 1 &&
        file1.length() > 8 && file1.substr(file1.length()-8,8)==".NEMESIS")
        containsManyFiles = true;

    if (containsManyFiles)
    {
        const char *filename = list[0];
        char  **reallist  = NULL;
        int     listcount = 0;
        avtDatabase::GetFileListFromTextFile(filename, reallist, listcount);

        avtDatabase *rv = ExodusCommonPluginInfo::SetupDatabase(reallist,
                                                                listcount,-1);

        //
        // Clean up memory
        //
        for (int i = 0 ; i < listcount ; i++)
        {
            delete [] reallist[i];
        }
        delete [] reallist;

        return rv;
    }

    //
    // We don't want to register the file list with every Exodus file format,
    // because that list can get big.  Instead, register a list statically
    // with the format.  It will return an index and then tell each new
    // instance that it should use this index.
    //
    int fileListId = -1;
    if (!containsManyFiles)
    {
        fileListId = avtExodusFileFormat::RegisterFileList(list, nList);
    }

    avtMTSDFileFormat **ffl = new avtMTSDFileFormat*[nList];
    for (int i = 0 ; i < nList ; i++)
    {
        avtExodusFileFormat *exo = new avtExodusFileFormat(list[i]);
        if (!containsManyFiles)
            exo->SetFileList(fileListId);
        ffl[i] = exo; 
    }
    avtMTSDFileFormatInterface *inter 
           = new avtMTSDFileFormatInterface(ffl, nList);
    return new avtGenericDatabase(inter);
}
